/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.caffeine.enhance;

import cn.herodotus.engine.cache.core.properties.CacheProperties;
import cn.herodotus.engine.cache.core.properties.Expire;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.caffeine.CaffeineCacheManager;

public class HerodotusCaffeineCacheManager
extends CaffeineCacheManager {
    private static final Logger log = LoggerFactory.getLogger(HerodotusCaffeineCacheManager.class);
    private final CacheProperties cacheProperties;

    public HerodotusCaffeineCacheManager(CacheProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
        this.setAllowNullValues(cacheProperties.getAllowNullValues());
    }

    public HerodotusCaffeineCacheManager(CacheProperties cacheProperties, String ... cacheNames) {
        super(cacheNames);
        this.cacheProperties = cacheProperties;
        this.setAllowNullValues(cacheProperties.getAllowNullValues());
    }

    protected Cache<Object, Object> createNativeCaffeineCache(String name) {
        String key;
        Map expires = this.cacheProperties.getExpires();
        if (MapUtils.isNotEmpty((Map)expires) && expires.containsKey(key = StringUtils.replace((String)name, (String)":", (String)this.cacheProperties.getSeparator()))) {
            Expire expire = (Expire)expires.get(key);
            log.debug("[Herodotus] |- CACHE - Caffeine cache [{}] is setted to use CUSTEM exprie.", (Object)name);
            return Caffeine.newBuilder().expireAfterWrite(expire.getDuration().longValue(), expire.getUnit()).build();
        }
        return super.createNativeCaffeineCache(name);
    }
}

