/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.processor;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaMediaAsyncCheckResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import cn.herodotus.engine.assistant.access.processor.WxappLogHandler;
import cn.herodotus.engine.assistant.access.properties.WxappProperties;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxappProcessor {
    private static final Logger log = LoggerFactory.getLogger(WxappProcessor.class);
    private final WxappProperties wxappProperties;
    private final WxappLogHandler wxappLogHandler;
    private final Map<String, WxMaMessageRouter> wxMaMessageRouters;
    private final Map<String, WxMaService> wxMaServices;

    public WxappProcessor(WxappProperties wxappProperties) {
        this.wxappProperties = wxappProperties;
        this.wxappLogHandler = new WxappLogHandler();
        this.wxMaMessageRouters = Maps.newHashMap();
        this.wxMaServices = this.initWxMaServices(this.wxappProperties, this.wxMaMessageRouters);
    }

    private Map<String, WxMaService> initWxMaServices(WxappProperties wxappProperties, Map<String, WxMaMessageRouter> wxMaMessageRouters) {
        List<WxappProperties.Config> configs = wxappProperties.getConfigs();
        if (CollectionUtils.isNotEmpty(configs)) {
            log.info("[Herodotus] |- Bean [Weixin Mini App] Configure.");
            return configs.stream().map(a -> {
                WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
                config.setAppid(a.getAppId());
                config.setSecret(a.getSecret());
                config.setToken(a.getToken());
                config.setAesKey(a.getAesKey());
                config.setMsgDataFormat(a.getMessageDataFormat());
                WxMaServiceImpl service = new WxMaServiceImpl();
                service.setWxMaConfig((WxMaConfig)config);
                wxMaMessageRouters.put(a.getAppId(), this.newRouter((WxMaService)service));
                return service;
            }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));
        }
        throw new WxRuntimeException("Weixin Mini App Configuraiton is not setting!");
    }

    private WxMaMessageRouter newRouter(WxMaService wxMaService) {
        WxMaMessageRouter router = new WxMaMessageRouter(wxMaService);
        router.rule().handler((WxMaMessageHandler)this.wxappLogHandler).next();
        return router;
    }

    public WxMaService getWxMaService(String appid) {
        WxMaService wxMaService = this.wxMaServices.get(appid);
        if (ObjectUtils.isEmpty((Object)wxMaService)) {
            throw new IllegalArgumentException(String.format("Cannot find the configuration of appid=[%s], please check!", appid));
        }
        return wxMaService;
    }

    public WxMaMessageRouter getWxMaMessageRouter(String appid) {
        return this.wxMaMessageRouters.get(appid);
    }

    public WxMaService getWxMaService() {
        String appId = this.wxappProperties.getDefaultAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.error("[Herodotus] |- Must set [herodotus.platform.social.wxapp.default-app-id] property, or use getWxMaService(String appid)!");
            throw new IllegalArgumentException("Must set [herodotus.platform.social.wxapp.default-app-id] property");
        }
        return this.getWxMaService(appId);
    }

    private WxMaJscode2SessionResult getSessionInfo(String code, WxMaService wxMaService) {
        try {
            WxMaJscode2SessionResult sessionResult = wxMaService.getUserService().getSessionInfo(code);
            log.debug("[Herodotus] |- Weixin Mini App login successfully!");
            return sessionResult;
        }
        catch (WxErrorException e) {
            log.error("[Herodotus] |- Weixin Mini App login failed! For reason: {}", (Object)e.getMessage());
            return null;
        }
    }

    public WxMaJscode2SessionResult login(String code, String appId) {
        WxMaService wxMaService = this.getWxMaService(appId);
        if (StringUtils.isNotBlank((CharSequence)code) && ObjectUtils.isNotEmpty((Object)wxMaService)) {
            return this.getSessionInfo(code, wxMaService);
        }
        log.error("[Herodotus] |- Weixin Mini App login failed, please check code param!");
        return null;
    }

    private boolean checkUserInfo(String sessionKey, String rawData, String signature, WxMaService wxMaService) {
        if (wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            log.debug("[Herodotus] |- Weixin Mini App user info is valid!");
            return true;
        }
        log.warn("[Herodotus] |- Weixin Mini App user check failed!");
        return false;
    }

    private boolean checkUserInfo(String rawData, String signature) {
        return StringUtils.isNotBlank((CharSequence)rawData) && StringUtils.isNotBlank((CharSequence)signature);
    }

    private WxMaUserInfo getUserInfo(String sessionKey, String encryptedData, String iv, WxMaService wxMaService) {
        WxMaUserInfo wxMaUserInfo = wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        log.debug("[Herodotus] |- Weixin Mini App get user info successfully!");
        return wxMaUserInfo;
    }

    public WxMaUserInfo getUserInfo(String appId, String sessionKey, String encryptedData, String iv) {
        return this.getUserInfo(appId, sessionKey, encryptedData, iv, null, null);
    }

    public WxMaUserInfo getUserInfo(String appId, String sessionKey, String encryptedData, String iv, String rawData, String signature) {
        WxMaService wxMaService = this.getWxMaService(appId);
        if (ObjectUtils.isNotEmpty((Object)wxMaService)) {
            if (this.checkUserInfo(rawData, signature) && this.checkUserInfo(sessionKey, rawData, signature, wxMaService)) {
                return null;
            }
            return this.getUserInfo(sessionKey, encryptedData, iv, wxMaService);
        }
        log.error("[Herodotus] |- Weixin Mini App get user info failed!");
        return null;
    }

    private WxMaPhoneNumberInfo getPhoneNumberInfo(String code, WxMaService wxMaService) {
        log.info("[Herodotus] |- Weixin Mini App get code\uff1a {}", (Object)code);
        try {
            WxMaPhoneNumberInfo wxMaPhoneNumberInfo = wxMaService.getUserService().getPhoneNumber(code);
            log.debug("[Herodotus] |- Weixin Mini App get phone number successfully! WxMaPhoneNumberInfo : {}", (Object)wxMaPhoneNumberInfo.toString());
            return wxMaPhoneNumberInfo;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Weixin Mini App get phone number failed!");
            return null;
        }
    }

    public WxMaPhoneNumberInfo getPhoneNumberInfo(String appId, String sessionKey, String rawData, String signature, String code) {
        WxMaService wxMaService = this.getWxMaService(appId);
        if (ObjectUtils.isNotEmpty((Object)wxMaService)) {
            if (this.checkUserInfo(rawData, signature) && this.checkUserInfo(sessionKey, rawData, signature, wxMaService)) {
                return null;
            }
            return this.getPhoneNumberInfo(code, wxMaService);
        }
        log.error("[Herodotus] |- Weixin Mini App get phone number info failed!");
        return null;
    }

    public boolean sendSubscribeMessage(String appId, WxMaSubscribeMessage subscribeMessage) {
        try {
            this.getWxMaService(appId).getMsgService().sendSubscribeMsg(subscribeMessage);
            log.debug("[Herodotus] |- Send Subscribe Message Successfully!");
            return true;
        }
        catch (WxErrorException e) {
            log.debug("[Herodotus] |- Send Subscribe Message Failed!", (Throwable)e);
            return false;
        }
    }

    public boolean checkMessage(String appId, String message) {
        try {
            this.getWxMaService(appId).getSecurityService().checkMessage(message);
            log.debug("[Herodotus] |- Check Message Successfully!");
            return true;
        }
        catch (WxErrorException e) {
            log.debug("[Herodotus] |- Check Message Failed!", (Throwable)e);
            return false;
        }
    }

    public boolean checkImage(String appId, String fileUrl) {
        try {
            this.getWxMaService(appId).getSecurityService().checkImage(fileUrl);
            log.debug("[Herodotus] |- Check Image use fileUrl Successfully!");
            return true;
        }
        catch (WxErrorException e) {
            log.debug("[Herodotus] |- Check Image use fileUrl Failed! Detail is \uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean checkImage(String appId, File file) {
        try {
            this.getWxMaService(appId).getSecurityService().checkImage(file);
            log.debug("[Herodotus] |- Check Image use file Successfully!");
            return true;
        }
        catch (WxErrorException e) {
            log.debug("[Herodotus] |- Check Image use file Failed! Detail is \uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public WxMaMediaAsyncCheckResult mediaAsyncCheck(String appId, String mediaUrl, int mediaType) {
        WxMaMediaAsyncCheckResult wxMaMediaAsyncCheckResult = null;
        try {
            wxMaMediaAsyncCheckResult = this.getWxMaService(appId).getSecurityService().mediaCheckAsync(mediaUrl, mediaType);
            log.debug("[Herodotus] |- Media Async Check Successfully!");
        }
        catch (WxErrorException e) {
            log.debug("[Herodotus] |- Media Async Check Failed! Detail is \uff1a{}", (Object)e.getMessage());
        }
        return wxMaMediaAsyncCheckResult;
    }
}

