/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.processor;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.herodotus.engine.assistant.access.definition.AccessHandler;
import cn.herodotus.engine.assistant.access.definition.domain.AccessResponse;
import cn.herodotus.engine.assistant.access.definition.domain.AccessUserDetails;
import cn.herodotus.engine.assistant.access.exception.AccessIdentityVerificationFailedException;
import cn.herodotus.engine.assistant.access.exception.AccessPreProcessFailedException;
import cn.herodotus.engine.assistant.access.processor.WxappProcessor;
import cn.herodotus.engine.core.identity.domain.AccessPrincipal;
import cn.herodotus.engine.core.identity.enums.AccountCategory;
import org.apache.commons.lang3.ObjectUtils;

public class WxappAccessHandler
implements AccessHandler {
    private final WxappProcessor wxappProcessor;

    public WxappAccessHandler(WxappProcessor wxappProcessor) {
        this.wxappProcessor = wxappProcessor;
    }

    @Override
    public AccessResponse preProcess(String core, String ... params) {
        WxMaJscode2SessionResult wxMaSession = this.wxappProcessor.login(core, params[0]);
        if (ObjectUtils.isNotEmpty((Object)wxMaSession)) {
            AccessResponse accessResponse = new AccessResponse();
            accessResponse.setSession(wxMaSession);
            return accessResponse;
        }
        throw new AccessPreProcessFailedException("Wxapp login failed");
    }

    @Override
    public AccessUserDetails loadUserDetails(String source, AccessPrincipal accessPrincipal) {
        WxMaUserInfo wxMaUserInfo = this.wxappProcessor.getUserInfo(accessPrincipal.getAppId(), accessPrincipal.getSessionKey(), accessPrincipal.getEncryptedData(), accessPrincipal.getIv());
        if (ObjectUtils.isNotEmpty((Object)wxMaUserInfo)) {
            return this.convertWxMaUserInfoToAccessUserDetails(wxMaUserInfo, accessPrincipal);
        }
        throw new AccessIdentityVerificationFailedException("Can not find the userinfo from Wechat!");
    }

    private AccessUserDetails convertWxMaUserInfoToAccessUserDetails(WxMaUserInfo wxMaUserInfo, AccessPrincipal accessPrincipal) {
        AccessUserDetails accessUserDetails = new AccessUserDetails();
        accessUserDetails.setUuid(accessPrincipal.getOpenId());
        accessUserDetails.setUsername(wxMaUserInfo.getNickName());
        accessUserDetails.setNickname(wxMaUserInfo.getNickName());
        accessUserDetails.setAvatar(wxMaUserInfo.getAvatarUrl());
        accessUserDetails.setLocation(wxMaUserInfo.getCountry() + "/" + wxMaUserInfo.getProvince() + "/" + wxMaUserInfo.getCity());
        accessUserDetails.setSource(AccountCategory.WXAPP.name());
        accessUserDetails.setOpenId(accessPrincipal.getOpenId());
        accessUserDetails.setUnionId(accessPrincipal.getUnionId());
        accessUserDetails.setAppId(wxMaUserInfo.getWatermark().getAppid());
        accessUserDetails.setPhoneNumber(wxMaUserInfo.getWatermark().getAppid());
        return accessUserDetails;
    }
}

