/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.processor;

import cn.herodotus.engine.assistant.access.exception.AccessConfigErrorException;
import cn.herodotus.engine.assistant.access.exception.IllegalAccessSourceException;
import cn.herodotus.engine.assistant.access.properties.JustAuthProperties;
import cn.herodotus.engine.assistant.access.stamp.JustAuthStateStampManager;
import cn.hutool.v7.core.util.EnumUtil;
import java.util.Map;
import java.util.stream.Collectors;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.request.AuthAlipayRequest;
import me.zhyd.oauth.request.AuthAliyunRequest;
import me.zhyd.oauth.request.AuthBaiduRequest;
import me.zhyd.oauth.request.AuthCodingRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;
import me.zhyd.oauth.request.AuthDouyinRequest;
import me.zhyd.oauth.request.AuthElemeRequest;
import me.zhyd.oauth.request.AuthFacebookRequest;
import me.zhyd.oauth.request.AuthFeishuRequest;
import me.zhyd.oauth.request.AuthGiteeRequest;
import me.zhyd.oauth.request.AuthGithubRequest;
import me.zhyd.oauth.request.AuthGitlabRequest;
import me.zhyd.oauth.request.AuthGoogleRequest;
import me.zhyd.oauth.request.AuthHuaweiV3Request;
import me.zhyd.oauth.request.AuthJdRequest;
import me.zhyd.oauth.request.AuthKujialeRequest;
import me.zhyd.oauth.request.AuthLinkedinRequest;
import me.zhyd.oauth.request.AuthMeituanRequest;
import me.zhyd.oauth.request.AuthMiRequest;
import me.zhyd.oauth.request.AuthMicrosoftRequest;
import me.zhyd.oauth.request.AuthOschinaRequest;
import me.zhyd.oauth.request.AuthPinterestRequest;
import me.zhyd.oauth.request.AuthQqRequest;
import me.zhyd.oauth.request.AuthRenrenRequest;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.AuthStackOverflowRequest;
import me.zhyd.oauth.request.AuthTaobaoRequest;
import me.zhyd.oauth.request.AuthTeambitionRequest;
import me.zhyd.oauth.request.AuthToutiaoRequest;
import me.zhyd.oauth.request.AuthTwitterRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseQrcodeRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseWebRequest;
import me.zhyd.oauth.request.AuthWeChatMpRequest;
import me.zhyd.oauth.request.AuthWeChatOpenRequest;
import me.zhyd.oauth.request.AuthWeiboRequest;
import me.zhyd.oauth.request.AuthXmlyRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JustAuthProcessor {
    private JustAuthProperties justAuthProperties;
    private JustAuthStateStampManager justAuthStateStampManager;

    public void setJustAuthProperties(JustAuthProperties justAuthProperties) {
        this.justAuthProperties = justAuthProperties;
    }

    public void setJustAuthStateRedisCache(JustAuthStateStampManager justAuthStateStampManager) {
        this.justAuthStateStampManager = justAuthStateStampManager;
    }

    private JustAuthStateStampManager getJustAuthStateRedisCache() {
        return this.justAuthStateStampManager;
    }

    public AuthRequest getAuthRequest(String source) {
        AuthDefaultSource authDefaultSource = JustAuthProcessor.parseAuthDefaultSource(source);
        AuthConfig authConfig = this.getAuthConfig(authDefaultSource);
        return this.getAuthRequest(authDefaultSource, authConfig);
    }

    public AuthRequest getAuthRequest(String source, AuthConfig authConfig) {
        AuthDefaultSource authDefaultSource = JustAuthProcessor.parseAuthDefaultSource(source);
        return this.getAuthRequest(authDefaultSource, authConfig);
    }

    public String getAuthorizeUrl(String source) {
        AuthRequest authRequest = this.getAuthRequest(source);
        return authRequest.authorize(AuthStateUtils.createState());
    }

    public String getAuthorizeUrl(String source, AuthConfig authConfig) {
        AuthRequest authRequest = this.getAuthRequest(source, authConfig);
        return authRequest.authorize(AuthStateUtils.createState());
    }

    public Map<String, String> getAuthorizeUrls() {
        Map<String, AuthConfig> configs = this.getConfigs();
        return configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getAuthorizeUrl((String)entry.getKey(), (AuthConfig)entry.getValue())));
    }

    @NotNull
    private Map<String, AuthConfig> getConfigs() {
        Map<String, AuthConfig> configs = this.justAuthProperties.getConfigs();
        if (MapUtils.isEmpty(configs)) {
            throw new AccessConfigErrorException();
        }
        return configs;
    }

    @NotNull
    private AuthConfig getAuthConfig(AuthDefaultSource authDefaultSource) {
        Map<String, AuthConfig> configs = this.getConfigs();
        AuthConfig authConfig = configs.get(authDefaultSource.name());
        if (ObjectUtils.isEmpty((Object)authConfig)) {
            throw new AccessConfigErrorException();
        }
        return authConfig;
    }

    private static AuthDefaultSource parseAuthDefaultSource(String source) {
        AuthDefaultSource authDefaultSource;
        try {
            authDefaultSource = (AuthDefaultSource)EnumUtil.fromString(AuthDefaultSource.class, (String)source.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalAccessSourceException();
        }
        return authDefaultSource;
    }

    private AuthRequest getAuthRequest(AuthDefaultSource authDefaultSource, AuthConfig authConfig) {
        return switch (authDefaultSource) {
            case AuthDefaultSource.GITHUB -> new AuthGithubRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.WEIBO -> new AuthWeiboRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.GITEE -> new AuthGiteeRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.DINGTALK -> new AuthDingTalkRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.BAIDU -> new AuthBaiduRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.CODING -> new AuthCodingRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.OSCHINA -> new AuthOschinaRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.ALIPAY -> new AuthAlipayRequest(authConfig, this.justAuthProperties.getAlipayPublicKey(), (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.QQ -> new AuthQqRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.WECHAT_MP -> new AuthWeChatMpRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.WECHAT_OPEN -> new AuthWeChatOpenRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.WECHAT_ENTERPRISE -> new AuthWeChatEnterpriseQrcodeRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.WECHAT_ENTERPRISE_WEB -> new AuthWeChatEnterpriseWebRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.TAOBAO -> new AuthTaobaoRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.GOOGLE -> new AuthGoogleRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.FACEBOOK -> new AuthFacebookRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.DOUYIN -> new AuthDouyinRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.LINKEDIN -> new AuthLinkedinRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.MICROSOFT -> new AuthMicrosoftRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.MI -> new AuthMiRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.TOUTIAO -> new AuthToutiaoRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.TEAMBITION -> new AuthTeambitionRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.RENREN -> new AuthRenrenRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.PINTEREST -> new AuthPinterestRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.STACK_OVERFLOW -> new AuthStackOverflowRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.HUAWEI_V3 -> new AuthHuaweiV3Request(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.GITLAB -> new AuthGitlabRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.KUJIALE -> new AuthKujialeRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.ELEME -> new AuthElemeRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.MEITUAN -> new AuthMeituanRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.TWITTER -> new AuthTwitterRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.FEISHU -> new AuthFeishuRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.JD -> new AuthJdRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.ALIYUN -> new AuthAliyunRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            case AuthDefaultSource.XMLY -> new AuthXmlyRequest(authConfig, (AuthStateCache)this.getJustAuthStateRedisCache());
            default -> null;
        };
    }
}

