/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.processor;

import cn.herodotus.engine.assistant.access.definition.AccessHandler;
import cn.herodotus.engine.assistant.access.definition.domain.AccessResponse;
import cn.herodotus.engine.assistant.access.definition.domain.AccessUserDetails;
import cn.herodotus.engine.assistant.access.exception.AccessIdentityVerificationFailedException;
import cn.herodotus.engine.assistant.access.processor.JustAuthProcessor;
import cn.herodotus.engine.core.identity.domain.AccessPrincipal;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;
import org.apache.commons.lang3.ObjectUtils;

public class JustAuthAccessHandler
implements AccessHandler {
    private final JustAuthProcessor justAuthProcessor;

    public JustAuthAccessHandler(JustAuthProcessor justAuthProcessor) {
        this.justAuthProcessor = justAuthProcessor;
    }

    @Override
    public AccessResponse preProcess(String core, String ... params) {
        String url = this.justAuthProcessor.getAuthorizeUrl(core);
        AccessResponse accessResponse = new AccessResponse();
        accessResponse.setAuthorizeUrl(url);
        return accessResponse;
    }

    @Override
    public AccessUserDetails loadUserDetails(String source, AccessPrincipal accessPrincipal) {
        AuthCallback authCallback;
        AuthRequest authRequest = this.justAuthProcessor.getAuthRequest(source);
        AuthResponse response = authRequest.login(authCallback = AuthCallback.builder().code(accessPrincipal.getCode()).auth_code(accessPrincipal.getAuth_code()).state(accessPrincipal.getState()).authorization_code(accessPrincipal.getAuthorization_code()).oauth_token(accessPrincipal.getOauth_token()).oauth_verifier(accessPrincipal.getOauth_verifier()).build());
        if (response.ok()) {
            AuthUser authUser = (AuthUser)response.getData();
            return this.convertAuthUserToAccessUserDetails(authUser);
        }
        throw new AccessIdentityVerificationFailedException(response.getMsg());
    }

    private AccessUserDetails convertAuthUserToAccessUserDetails(AuthUser authUser) {
        AccessUserDetails sysSocialUser = new AccessUserDetails();
        sysSocialUser.setUuid(authUser.getUuid());
        sysSocialUser.setUsername(authUser.getUsername());
        sysSocialUser.setNickname(authUser.getNickname());
        sysSocialUser.setAvatar(authUser.getAvatar());
        sysSocialUser.setBlog(authUser.getBlog());
        sysSocialUser.setCompany(authUser.getCompany());
        sysSocialUser.setLocation(authUser.getLocation());
        sysSocialUser.setEmail(authUser.getEmail());
        sysSocialUser.setRemark(authUser.getRemark());
        sysSocialUser.setGender(authUser.getGender());
        sysSocialUser.setSource(authUser.getSource());
        AuthToken authToken = authUser.getToken();
        if (ObjectUtils.isNotEmpty((Object)authToken)) {
            this.setAccessUserInfo(sysSocialUser, authToken.getAccessToken(), authToken.getExpireIn(), authToken.getRefreshToken(), authToken.getRefreshTokenExpireIn(), authToken.getScope(), authToken.getTokenType(), authToken.getUid(), authToken.getOpenId(), authToken.getAccessCode(), authToken.getUnionId());
        }
        return sysSocialUser;
    }

    private void setAccessUserInfo(AccessUserDetails accessUserDetails, String accessToken, Integer expireIn, String refreshToken, Integer refreshTokenExpireIn, String scope, String tokenType, String uid, String openId, String accessCode, String unionId) {
        accessUserDetails.setAccessToken(accessToken);
        accessUserDetails.setExpireIn(expireIn);
        accessUserDetails.setRefreshToken(refreshToken);
        accessUserDetails.setRefreshTokenExpireIn(refreshTokenExpireIn);
        accessUserDetails.setScope(scope);
        accessUserDetails.setTokenType(tokenType);
        accessUserDetails.setUid(uid);
        accessUserDetails.setOpenId(openId);
        accessUserDetails.setAccessCode(accessCode);
        accessUserDetails.setUnionId(unionId);
    }
}

