/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.factory;

import cn.herodotus.engine.assistant.access.definition.AccessHandler;
import cn.herodotus.engine.assistant.access.definition.domain.AccessResponse;
import cn.herodotus.engine.assistant.access.definition.domain.AccessUserDetails;
import cn.herodotus.engine.assistant.access.exception.AccessHandlerNotFoundException;
import cn.herodotus.engine.assistant.access.exception.IllegalAccessArgumentException;
import cn.herodotus.engine.core.identity.domain.AccessPrincipal;
import cn.herodotus.engine.core.identity.enums.AccountCategory;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccessHandlerStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(AccessHandlerStrategyFactory.class);
    private final Map<String, AccessHandler> handlers;

    public AccessHandlerStrategyFactory(Map<String, AccessHandler> handlers) {
        this.handlers = handlers;
    }

    public AccessResponse preProcess(String source, String core, String ... params) {
        AccessHandler socialAuthenticationHandler = this.getAccessHandler(source);
        return socialAuthenticationHandler.preProcess(core, params);
    }

    public AccessResponse preProcess(AccountCategory accountCategory, String core, String ... params) {
        AccessHandler socialAuthenticationHandler = this.getAccessHandler(accountCategory);
        return socialAuthenticationHandler.preProcess(core, params);
    }

    public AccessUserDetails findAccessUserDetails(String source, AccessPrincipal accessPrincipal) {
        AccessHandler socialAuthenticationHandler = this.getAccessHandler(source);
        AccessUserDetails accessUserDetails = socialAuthenticationHandler.loadUserDetails(source, accessPrincipal);
        log.debug("[Herodotus] |- AccessHandlerFactory findAccessUserDetails.");
        return accessUserDetails;
    }

    public AccessHandler getAccessHandler(String source) {
        if (ObjectUtils.isEmpty((Object)source)) {
            throw new IllegalAccessArgumentException("Cannot found SocialProvider");
        }
        AccountCategory accountCategory = AccountCategory.getAccountType((String)source);
        if (ObjectUtils.isEmpty((Object)accountCategory)) {
            throw new IllegalAccessArgumentException("Cannot parse the source parameter.");
        }
        return this.getAccessHandler(accountCategory);
    }

    public AccessHandler getAccessHandler(AccountCategory accountCategory) {
        String handlerName = accountCategory.getHandler();
        AccessHandler socialAuthenticationHandler = this.handlers.get(handlerName);
        if (ObjectUtils.isNotEmpty((Object)socialAuthenticationHandler)) {
            return socialAuthenticationHandler;
        }
        throw new AccessHandlerNotFoundException("Can not found Social Handler for " + handlerName);
    }
}

