/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.config;

import cn.herodotus.engine.assistant.access.condition.ConditionalOnWxappEnabled;
import cn.herodotus.engine.assistant.access.processor.WxappAccessHandler;
import cn.herodotus.engine.assistant.access.processor.WxappProcessor;
import cn.herodotus.engine.assistant.access.properties.WxappProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWxappEnabled
@EnableConfigurationProperties(value={WxappProperties.class})
public class AssistantAccessWxappConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AssistantAccessWxappConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- Module [Assistant Access Wxapp] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public WxappProcessor wxappProcessor(WxappProperties wxappProperties) {
        WxappProcessor wxappProcessor = new WxappProcessor(wxappProperties);
        log.trace("[Herodotus] |- Bean [Wxapp Processor] Configure.");
        return wxappProcessor;
    }

    @Bean(value={"WECHAT_MINI_APP"})
    @ConditionalOnBean(value={WxappProcessor.class})
    @ConditionalOnMissingBean
    public WxappAccessHandler wxappAccessHandler(WxappProcessor wxappProcessor) {
        WxappAccessHandler wxappAccessHandler = new WxappAccessHandler(wxappProcessor);
        log.debug("[Herodotus] |- Bean [Wxapp Access Handler] Configure.");
        return wxappAccessHandler;
    }
}

