/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.config;

import cn.herodotus.engine.assistant.access.condition.ConditionalOnJustAuthEnabled;
import cn.herodotus.engine.assistant.access.processor.JustAuthAccessHandler;
import cn.herodotus.engine.assistant.access.processor.JustAuthProcessor;
import cn.herodotus.engine.assistant.access.properties.JustAuthProperties;
import cn.herodotus.engine.assistant.access.stamp.JustAuthStateStampManager;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnJustAuthEnabled
@EnableConfigurationProperties(value={JustAuthProperties.class})
public class AssistantAccessJustAuthConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AssistantAccessJustAuthConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- Module [Assistant Access JustAuth] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public JustAuthStateStampManager justAuthStateStampManager(JustAuthProperties justAuthProperties) {
        JustAuthStateStampManager justAuthStateStampManager = new JustAuthStateStampManager(justAuthProperties);
        log.trace("[Herodotus] |- Bean [Just Auth State Redis Cache] Configure.");
        return justAuthStateStampManager;
    }

    @Bean
    @ConditionalOnBean(value={JustAuthStateStampManager.class})
    @ConditionalOnMissingBean
    public JustAuthProcessor justAuthProcessor(JustAuthStateStampManager justAuthStateStampManager, JustAuthProperties justAuthProperties) {
        JustAuthProcessor justAuthProcessor = new JustAuthProcessor();
        justAuthProcessor.setJustAuthStateRedisCache(justAuthStateStampManager);
        justAuthProcessor.setJustAuthProperties(justAuthProperties);
        log.trace("[Herodotus] |- Bean [Just Auth Request Generator] Configure.");
        return justAuthProcessor;
    }

    @Bean(value={"JUST_AUTH"})
    @ConditionalOnBean(value={JustAuthProcessor.class})
    @ConditionalOnMissingBean
    public JustAuthAccessHandler justAuthAccessHandler(JustAuthProcessor justAuthProcessor) {
        JustAuthAccessHandler justAuthAccessHandler = new JustAuthAccessHandler(justAuthProcessor);
        log.debug("[Herodotus] |- Bean [Just Auth Access Handler] Configure.");
        return justAuthAccessHandler;
    }
}

