/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.access.config;

import cn.herodotus.engine.assistant.access.config.AssistantAccessJustAuthConfiguration;
import cn.herodotus.engine.assistant.access.config.AssistantAccessSmsConfiguration;
import cn.herodotus.engine.assistant.access.config.AssistantAccessWxappConfiguration;
import cn.herodotus.engine.assistant.access.config.AssistantAccessWxmppConfiguration;
import cn.herodotus.engine.assistant.access.customizer.AccessErrorCodeMapperBuilderCustomizer;
import cn.herodotus.engine.assistant.access.definition.AccessHandler;
import cn.herodotus.engine.assistant.access.factory.AccessHandlerStrategyFactory;
import cn.herodotus.engine.core.definition.function.ErrorCodeMapperBuilderCustomizer;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@Import(value={AssistantAccessJustAuthConfiguration.class, AssistantAccessSmsConfiguration.class, AssistantAccessWxappConfiguration.class, AssistantAccessWxmppConfiguration.class})
public class AssistantAccessConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AssistantAccessConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- Module [Assistant Access] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessHandlerStrategyFactory accessHandlerStrategyFactory(Map<String, AccessHandler> handlers) {
        AccessHandlerStrategyFactory accessHandlerStrategyFactory = new AccessHandlerStrategyFactory(handlers);
        log.trace("[Herodotus] |- Bean [Access Handler Strategy Factory] Configure.");
        return accessHandlerStrategyFactory;
    }

    @Bean
    public ErrorCodeMapperBuilderCustomizer accessErrorCodeMapperBuilderCustomizer() {
        AccessErrorCodeMapperBuilderCustomizer customizer = new AccessErrorCodeMapperBuilderCustomizer();
        log.debug("[Herodotus] |- Strategy [Access ErrorCodeMapper Builder Customizer] Configure.");
        return customizer;
    }
}

