/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.access.wxmpp.processor;

import cn.herodotus.engine.access.wxmpp.processor.WxmppLogHandler;
import cn.herodotus.engine.access.wxmpp.properties.WxmppProperties;
import java.util.List;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.StringRedisTemplate;

public class WxmppProcessor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WxmppProcessor.class);
    private WxMpService wxMpService;
    private WxmppProperties wxmppProperties;
    private WxmppLogHandler wxmppLogHandler;
    private StringRedisTemplate stringRedisTemplate;

    public void setWxmppProperties(WxmppProperties wxmppProperties) {
        this.wxmppProperties = wxmppProperties;
    }

    public void setWxmppLogHandler(WxmppLogHandler wxmppLogHandler) {
        this.wxmppLogHandler = wxmppLogHandler;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        List<WxmppProperties.MpConfig> configs = this.wxmppProperties.getConfigs();
        if (configs == null) {
            throw new RuntimeException("\u5927\u54e5\uff0c\u62dc\u6258\u5148\u770b\u4e0b\u9879\u76ee\u9996\u9875\u7684\u8bf4\u660e\uff08readme\u6587\u4ef6\uff09\uff0c\u6dfb\u52a0\u4e0b\u76f8\u5173\u914d\u7f6e\uff0c\u6ce8\u610f\u522b\u914d\u9519\u4e86\uff01");
        }
        WxMpServiceImpl wxMpService = new WxMpServiceImpl();
        wxMpService.setMultiConfigStorages(configs.stream().map(a -> {
            WxMpDefaultConfigImpl configStorage;
            if (this.wxmppProperties.isUseRedis()) {
                WxmppProperties.RedisConfig redisConfig = this.wxmppProperties.getRedis();
                configStorage = new WxMpRedisConfigImpl((WxRedisOps)new RedisTemplateWxRedisOps(this.stringRedisTemplate), a.getAppId());
            } else {
                configStorage = new WxMpDefaultConfigImpl();
            }
            configStorage.setAppId(a.getAppId());
            configStorage.setSecret(a.getSecret());
            configStorage.setToken(a.getToken());
            configStorage.setAesKey(a.getAesKey());
            return configStorage;
        }).collect(Collectors.toMap(WxMpDefaultConfigImpl::getAppId, a -> a, (o, n) -> o)));
        log.info("[Herodotus] |- Bean [Herodotus Weixin Micro Message Public Platform] Auto Configure.");
        this.wxMpService = wxMpService;
    }

    public WxMpService getWxMpService() {
        if (ObjectUtils.isEmpty((Object)this.wxMpService)) {
            throw new IllegalArgumentException(String.format("Cannot find the configuration for wechat official accounts, please check!", new Object[0]));
        }
        return this.wxMpService;
    }

    public WxMpMessageRouter getWxMpMessageRouter() {
        WxMpMessageRouter newRouter = new WxMpMessageRouter(this.getWxMpService());
        newRouter.rule().handler((WxMpMessageHandler)this.wxmppLogHandler).next();
        return newRouter;
    }
}

