/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.access.wxmpp.configuration;

import cn.herodotus.engine.access.wxmpp.annotation.ConditionalOnWxmppEnabled;
import cn.herodotus.engine.access.wxmpp.processor.WxmppLogHandler;
import cn.herodotus.engine.access.wxmpp.processor.WxmppProcessor;
import cn.herodotus.engine.access.wxmpp.properties.WxmppProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWxmppEnabled
@EnableConfigurationProperties(value={WxmppProperties.class})
public class WxmppConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxmppConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- SDK [Access Wxmpp] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public WxmppProcessor wxmppProcessor(WxmppProperties wxmppProperties, StringRedisTemplate stringRedisTemplate) {
        WxmppProcessor wxmppProcessor = new WxmppProcessor();
        wxmppProcessor.setWxmppProperties(wxmppProperties);
        wxmppProcessor.setWxmppLogHandler(new WxmppLogHandler());
        wxmppProcessor.setStringRedisTemplate(stringRedisTemplate);
        log.trace("[Herodotus] |- Bean [Wxmpp Processor] Auto Configure.");
        return wxmppProcessor;
    }
}

