/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.reactive.service;

import cn.herodotus.oss.core.minio.bo.ObjectSettingBusiness;
import cn.herodotus.oss.core.minio.converter.ResponseToStatObjectDomainConverter;
import cn.herodotus.oss.core.minio.domain.StatObjectDomain;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioObjectService;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioObjectTagsService;
import io.minio.StatObjectResponse;
import io.minio.messages.Tags;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioObjectSettingService {
    private final Converter<StatObjectResponse, StatObjectDomain> toStatObjectDomain;
    private final MinioObjectService minioObjectService;
    private final MinioObjectTagsService minioObjectTagsService;

    public MinioObjectSettingService(MinioObjectService minioObjectService, MinioObjectTagsService minioObjectTagsService) {
        this.minioObjectService = minioObjectService;
        this.minioObjectTagsService = minioObjectTagsService;
        this.toStatObjectDomain = new ResponseToStatObjectDomainConverter();
    }

    public Mono<ObjectSettingBusiness> get(String bucketName, String region, String objectName) {
        Mono statObjectResponse = this.minioObjectService.statObject(bucketName, region, objectName);
        Mono tags = this.minioObjectTagsService.getObjectTags(bucketName, region, objectName);
        return statObjectResponse.mapNotNull(arg_0 -> this.toStatObjectDomain.convert(arg_0)).zipWith(tags).map(item -> {
            ObjectSettingBusiness business = new ObjectSettingBusiness();
            business.setTags(((Tags)item.getT2()).get());
            business.setRetentionMode(((StatObjectDomain)item.getT1()).getRetentionMode());
            business.setRetentionRetainUntilDate(((StatObjectDomain)item.getT1()).getRetentionRetainUntilDate());
            business.setLegalHold(((StatObjectDomain)item.getT1()).getLegalHold());
            business.setDeleteMarker(((StatObjectDomain)item.getT1()).getDeleteMarker());
            business.setEtag(((StatObjectDomain)item.getT1()).getEtag());
            business.setLastModified(((StatObjectDomain)item.getT1()).getLastModified());
            business.setSize(((StatObjectDomain)item.getT1()).getSize());
            business.setUserMetadata(((StatObjectDomain)item.getT1()).getUserMetadata());
            return business;
        });
    }
}

