/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.reactive.service;

import cn.herodotus.oss.core.minio.bo.BucketSettingBusiness;
import cn.herodotus.oss.core.minio.converter.retention.ObjectLockConfigurationToDomainConverter;
import cn.herodotus.oss.core.minio.converter.retention.VersioningConfigurationToDomainConverter;
import cn.herodotus.oss.core.minio.converter.sse.SseConfigurationToEnumConverter;
import cn.herodotus.oss.core.minio.domain.ObjectLockConfigurationDomain;
import cn.herodotus.oss.core.minio.domain.VersioningConfigurationDomain;
import cn.herodotus.oss.core.minio.enums.PolicyEnums;
import cn.herodotus.oss.core.minio.enums.SseConfigurationEnums;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioBucketEncryptionService;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioBucketPolicyService;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioBucketQuotaService;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioBucketTagsService;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioBucketVersioningService;
import cn.herodotus.oss.dialect.reactive.minio.service.MinioObjectLockConfigurationService;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Tags;
import io.minio.messages.VersioningConfiguration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketSettingService {
    private final Converter<SseConfiguration, SseConfigurationEnums> toSseConfigurationEnums;
    private final Converter<ObjectLockConfiguration, ObjectLockConfigurationDomain> toObjectLockDomain;
    private final Converter<VersioningConfiguration, VersioningConfigurationDomain> toVersioningDomain;
    private final MinioBucketEncryptionService minioBucketEncryptionService;
    private final MinioBucketPolicyService minioBucketPolicyService;
    private final MinioBucketTagsService minioBucketTagsService;
    private final MinioBucketVersioningService minioBucketVersioningService;
    private final MinioBucketQuotaService minioBucketQuotaService;
    private final MinioObjectLockConfigurationService minioObjectLockConfigurationService;

    public MinioBucketSettingService(MinioBucketEncryptionService minioBucketEncryptionService, MinioBucketPolicyService minioBucketPolicyService, MinioBucketTagsService minioBucketTagsService, MinioBucketVersioningService minioBucketVersioningService, MinioBucketQuotaService minioBucketQuotaService, MinioObjectLockConfigurationService minioObjectLockConfigurationService) {
        this.minioBucketEncryptionService = minioBucketEncryptionService;
        this.minioBucketPolicyService = minioBucketPolicyService;
        this.minioBucketTagsService = minioBucketTagsService;
        this.minioBucketVersioningService = minioBucketVersioningService;
        this.minioBucketQuotaService = minioBucketQuotaService;
        this.minioObjectLockConfigurationService = minioObjectLockConfigurationService;
        this.toSseConfigurationEnums = new SseConfigurationToEnumConverter();
        this.toObjectLockDomain = new ObjectLockConfigurationToDomainConverter();
        this.toVersioningDomain = new VersioningConfigurationToDomainConverter();
    }

    public Mono<BucketSettingBusiness> get(String bucketName) {
        return this.get(bucketName, null);
    }

    public Mono<BucketSettingBusiness> get(String bucketName, String region) {
        Mono sseConfiguration = this.minioBucketEncryptionService.getBucketEncryption(bucketName, region);
        Mono tags = this.minioBucketTagsService.getBucketTags(bucketName, region);
        Mono policy = this.minioBucketPolicyService.getBucketPolicy(bucketName, region);
        Mono objectLockConfiguration = this.minioObjectLockConfigurationService.getObjectLockConfiguration(bucketName, region);
        Mono versioningConfiguration = this.minioBucketVersioningService.getBucketVersioning(bucketName, region);
        Mono quota = this.minioBucketQuotaService.getBucketQuota(bucketName);
        return Mono.zip((Mono)sseConfiguration, (Mono)tags, (Mono)policy, (Mono)objectLockConfiguration, (Mono)versioningConfiguration, (Mono)quota).map(tuple -> {
            BucketSettingBusiness entity = new BucketSettingBusiness();
            entity.setSseConfiguration((SseConfigurationEnums)this.toSseConfigurationEnums.convert((Object)((SseConfiguration)tuple.getT1())));
            entity.setTags(((Tags)tuple.getT2()).get());
            entity.setPolicy((PolicyEnums)tuple.getT3());
            entity.setObjectLock((ObjectLockConfigurationDomain)this.toObjectLockDomain.convert((Object)((ObjectLockConfiguration)tuple.getT4())));
            entity.setVersioning((VersioningConfigurationDomain)this.toVersioningDomain.convert((Object)((VersioningConfiguration)tuple.getT5())));
            entity.setQuota((Long)tuple.getT6());
            return entity;
        });
    }
}

