/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.reactive.controller;

import cn.herodotus.oss.dialect.reactive.minio.service.MinioAdminPolicyService;
import cn.herodotus.oss.rest.minio.reactive.definition.OssController;
import cn.herodotus.oss.rest.minio.reactive.response.VoidResponse;
import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.web.core.annotation.AccessLimited;
import cn.herodotus.stirrup.web.core.annotation.Idempotent;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/oss/minio/admin/policy"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5c4f\u853d\u7b56\u7565\u7ba1\u7406\u63a5\u53e3")})
public class MinioAdminPolicyController
implements OssController {
    private final MinioAdminPolicyService minioAdminPolicyService;

    public MinioAdminPolicyController(MinioAdminPolicyService minioAdminPolicyService) {
        this.minioAdminPolicyService = minioAdminPolicyService;
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", description="\u83b7\u53d6\u5168\u90e8\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u6240\u6709\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f\uff0c\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @GetMapping(value={"/list"})
    public Mono<Result<Map<String, String>>> list() {
        Mono policies = this.minioAdminPolicyService.listCannedPolicies();
        return this.result(policies);
    }

    @Idempotent
    @Operation(summary="\u6dfb\u52a0\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", description="\u6dfb\u52a0\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API \u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="name", required=true, description="\u7528\u6237\u540d"), @Parameter(name="policy", required=true, description="\u5b89\u5168\u7b56\u7565")})
    @PostMapping
    public Mono<Result<VoidResponse>> add(@RequestParam(value="name") String name, @RequestParam(value="policy") String policy) {
        Mono result = this.minioAdminPolicyService.addCannedPolicy(name, policy);
        return this.fromVoid((Mono<Void>)result);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", description="\u5220\u9664\u5c4f\u853d\u7b56\u7565\u4fe1\u606f", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API \u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9"), @ApiResponse(responseCode="503", description="Minio Server \u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="name", required=true, description="\u5c4f\u853d\u7b56\u7565\u540d\u79f0")})
    @DeleteMapping
    public Mono<Result<VoidResponse>> remove(String name) {
        Mono result = this.minioAdminPolicyService.removeCannedPolicy(name);
        return this.fromVoid((Mono<Void>)result);
    }
}

