/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.converter.domain;

import cn.herodotus.oss.core.domain.object.DeleteObjectDomain;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;

public class DeleteObjectsResultToDomainConverter
implements Converter<DeleteObjectsResult, List<DeleteObjectDomain>> {
    public List<DeleteObjectDomain> convert(DeleteObjectsResult source) {
        List items = source.getDeletedObjects();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            return items.stream().map(item -> {
                DeleteObjectDomain domain = new DeleteObjectDomain();
                domain.setObjectName(item.getKey());
                domain.setVersionId(item.getVersionId());
                return domain;
            }).toList();
        }
        return new ArrayList<DeleteObjectDomain>();
    }
}

