/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.converter.arguments;

import cn.herodotus.oss.core.arguments.object.DeleteObjectsArguments;
import cn.herodotus.oss.dialect.s3.definition.arguments.ArgumentsToBucketConverter;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ArgumentsToDeleteObjectsRequestConverter
extends ArgumentsToBucketConverter<DeleteObjectsArguments, DeleteObjectsRequest> {
    @Override
    public void prepare(DeleteObjectsArguments arguments, DeleteObjectsRequest request) {
        List keys = arguments.getObjects();
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            List<DeleteObjectsRequest.KeyVersion> values = keys.stream().map(item -> new DeleteObjectsRequest.KeyVersion(item.getObjectName(), item.getVersionId())).toList();
            request.setKeys(values);
        }
        request.setQuiet(arguments.getQuiet().booleanValue());
        super.prepare(arguments, request);
    }

    public DeleteObjectsRequest getInstance(DeleteObjectsArguments arguments) {
        return new DeleteObjectsRequest(arguments.getBucketName());
    }
}

