/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.config;

import cn.herodotus.oss.core.s3.properties.S3Properties;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientPooledObjectFactory;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={S3Properties.class})
public class OssDialectS3Configuration {
    private static final Logger log = LoggerFactory.getLogger(OssDialectS3Configuration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Oss Dialect S3] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public S3ClientObjectPool s3ClientObjectPool(S3Properties s3Properties) {
        S3ClientPooledObjectFactory factory = new S3ClientPooledObjectFactory(s3Properties);
        S3ClientObjectPool pool = new S3ClientObjectPool(factory);
        log.trace("[Herodotus] |- Bean [S3 Client Pool] Configure.");
        return pool;
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackages={"cn.herodotus.oss.dialect.s3.service", "cn.herodotus.oss.dialect.s3.repository"})
    static class OssDialectS3ServiceConfiguration {
        OssDialectS3ServiceConfiguration() {
        }
    }
}

