/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.DeleteObjectTagsArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.SetObjectTagsArgs;
import io.minio.messages.Tags;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioObjectTagsService
extends BaseMinioAsyncService {
    public MinioObjectTagsService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<Tags> getObjectTags(String bucketName, String objectName) {
        return this.getObjectTags(bucketName, null, objectName);
    }

    public Mono<Tags> getObjectTags(String bucketName, String region, String objectName) {
        return this.getObjectTags(bucketName, region, objectName, null);
    }

    public Mono<Tags> getObjectTags(String bucketName, String region, String objectName, String versionId) {
        return this.getObjectTags((GetObjectTagsArgs)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)GetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).region(region)).versionId(versionId)).build());
    }

    public Mono<Tags> getObjectTags(GetObjectTagsArgs getObjectTagsArgs) {
        return this.fromFuture("getObjectTags", client -> client.getObjectTags(getObjectTagsArgs));
    }

    public Mono<Void> setObjectTags(String bucketName, String objectName, Tags tags) {
        return this.setObjectTags(bucketName, null, objectName, tags);
    }

    public Mono<Void> setObjectTags(String bucketName, String region, String objectName, Tags tags) {
        return this.setObjectTags(bucketName, region, objectName, tags, null);
    }

    public Mono<Void> setObjectTags(String bucketName, String region, String objectName, Tags tags, String versionId) {
        return this.setObjectTags((SetObjectTagsArgs)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)SetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).region(region)).versionId(versionId)).tags(tags).build());
    }

    public Mono<Void> setObjectTags(SetObjectTagsArgs setObjectTagsArgs) {
        return this.fromFuture("setObjectTags", client -> client.setObjectTags(setObjectTagsArgs));
    }

    public Mono<Void> deleteObjectTags(String bucketName, String objectName) {
        return this.deleteObjectTags(bucketName, null, objectName);
    }

    public Mono<Void> deleteObjectTags(String bucketName, String region, String objectName) {
        return this.deleteObjectTags(bucketName, region, objectName, null);
    }

    public Mono<Void> deleteObjectTags(String bucketName, String region, String objectName, String versionId) {
        return this.deleteObjectTags((DeleteObjectTagsArgs)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)DeleteObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).region(region)).versionId(versionId)).build());
    }

    public Mono<Void> deleteObjectTags(DeleteObjectTagsArgs deleteObjectTagsArgs) {
        return this.fromFuture("deleteObjectTags", client -> client.deleteObjectTags(deleteObjectTagsArgs));
    }
}

