/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.AbortMultipartUploadResponse;
import io.minio.CreateMultipartUploadResponse;
import io.minio.ListMultipartUploadsResponse;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.UploadPartCopyResponse;
import io.minio.UploadPartResponse;
import io.minio.messages.Part;
import java.util.Map;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioMultipartUploadService
extends BaseMinioAsyncService {
    public MinioMultipartUploadService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<CreateMultipartUploadResponse> createMultipartUpload(String bucketName, String objectName) {
        return this.createMultipartUpload(bucketName, null, objectName);
    }

    public Mono<CreateMultipartUploadResponse> createMultipartUpload(String bucketName, String region, String objectName) {
        return this.createMultipartUpload(bucketName, region, objectName, null, null);
    }

    public Mono<CreateMultipartUploadResponse> createMultipartUpload(String bucketName, String region, String objectName, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("createMultipartUpload", client -> client.createMultipartUploadAsync(bucketName, region, objectName, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }

    public Mono<UploadPartResponse> uploadPart(String bucketName, String objectName, Object data, long length, String uploadId, int partNumber) {
        return this.uploadPart(bucketName, null, objectName, data, length, uploadId, partNumber);
    }

    public Mono<UploadPartResponse> uploadPart(String bucketName, String region, String objectName, Object data, long length, String uploadId, int partNumber) {
        return this.uploadPart(bucketName, region, objectName, data, length, uploadId, partNumber, null, null);
    }

    public Mono<UploadPartResponse> uploadPart(String bucketName, String region, String objectName, Object data, long length, String uploadId, int partNumber, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("uploadPart", client -> client.uploadPartAsync(bucketName, region, objectName, data, length, uploadId, partNumber, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }

    public Mono<UploadPartCopyResponse> uploadPartCopy(String bucketName, String objectName, String uploadId, int partNumber) {
        return this.uploadPartCopy(bucketName, null, objectName, uploadId, partNumber);
    }

    public Mono<UploadPartCopyResponse> uploadPartCopy(String bucketName, String region, String objectName, String uploadId, int partNumber) {
        return this.uploadPartCopy(bucketName, region, objectName, uploadId, partNumber, null, null);
    }

    public Mono<UploadPartCopyResponse> uploadPartCopy(String bucketName, String region, String objectName, String uploadId, int partNumber, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("uploadPartCopy", client -> client.uploadPartCopyAsync(bucketName, region, objectName, uploadId, partNumber, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }

    public Mono<AbortMultipartUploadResponse> abortMultipartUpload(String bucketName, String objectName, String uploadId) {
        return this.abortMultipartUpload(bucketName, null, objectName, uploadId);
    }

    public Mono<AbortMultipartUploadResponse> abortMultipartUpload(String bucketName, String region, String objectName, String uploadId) {
        return this.abortMultipartUpload(bucketName, region, objectName, uploadId, null, null);
    }

    public Mono<AbortMultipartUploadResponse> abortMultipartUpload(String bucketName, String region, String objectName, String uploadId, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("abortMultipartUpload", client -> client.abortMultipartUploadAsync(bucketName, region, objectName, uploadId, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }

    public Mono<ObjectWriteResponse> completeMultipartUpload(String bucketName, String objectName, String uploadId, Part[] parts) {
        return this.completeMultipartUpload(bucketName, null, objectName, uploadId, parts);
    }

    public Mono<ObjectWriteResponse> completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts) {
        return this.completeMultipartUpload(bucketName, region, objectName, uploadId, parts, null, null);
    }

    public Mono<ObjectWriteResponse> completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("completeMultipartUpload", client -> client.completeMultipartUploadAsync(bucketName, region, objectName, uploadId, parts, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }

    public Mono<ListPartsResponse> listParts(String bucketName, String objectName, String uploadId) {
        return this.listParts(bucketName, objectName, null, uploadId);
    }

    public Mono<ListPartsResponse> listParts(String bucketName, String objectName, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, objectName, null, partNumberMarker, uploadId);
    }

    public Mono<ListPartsResponse> listParts(String bucketName, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, null, objectName, maxParts, partNumberMarker, uploadId);
    }

    public Mono<ListPartsResponse> listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, null, null);
    }

    public Mono<ListPartsResponse> listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("listParts", client -> client.listPartsAsync(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String delimiter, Integer maxUploads, String prefix) {
        return this.listMultipartUploads(bucketName, delimiter, null, maxUploads, prefix, null);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName) {
        return this.listMultipartUploads(bucketName, null);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String prefix) {
        return this.listMultipartUploads(bucketName, "/", prefix);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String delimiter, String prefix) {
        return this.listMultipartUploads(bucketName, delimiter, null, prefix);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String delimiter, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        return this.listMultipartUploads(bucketName, delimiter, null, keyMarker, maxUploads, prefix, uploadIdMarker);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        return this.listMultipartUploads(bucketName, null, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String region, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        return this.listMultipartUploads(bucketName, region, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker, null, null);
    }

    public Mono<ListMultipartUploadsResponse> listMultipartUploads(String bucketName, String region, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        return this.fromFuture("listMultipartUploads", client -> client.listMultipartUploadsAsync(bucketName, region, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)));
    }
}

