/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.GetBucketVersioningArgs;
import io.minio.SetBucketVersioningArgs;
import io.minio.messages.VersioningConfiguration;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketVersioningService
extends BaseMinioAsyncService {
    public MinioBucketVersioningService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<Void> enabledBucketVersioning(String bucketName) {
        return this.setBucketVersioning(bucketName, VersioningConfiguration.Status.ENABLED);
    }

    public Mono<Void> enabledBucketVersioning(String bucketName, String region) {
        return this.setBucketVersioning(bucketName, region, VersioningConfiguration.Status.ENABLED);
    }

    public Mono<Void> suspendedBucketVersioning(String bucketName) {
        return this.setBucketVersioning(bucketName, VersioningConfiguration.Status.SUSPENDED);
    }

    public Mono<Void> suspendedBucketVersioning(String bucketName, String region) {
        return this.setBucketVersioning(bucketName, region, VersioningConfiguration.Status.SUSPENDED);
    }

    public Mono<Void> offBucketVersioning(String bucketName) {
        return this.setBucketVersioning(bucketName, VersioningConfiguration.Status.OFF);
    }

    public Mono<Void> offBucketVersioning(String bucketName, String region) {
        return this.setBucketVersioning(bucketName, region, VersioningConfiguration.Status.OFF);
    }

    public Mono<Void> setBucketVersioning(String bucketName, VersioningConfiguration.Status status) {
        return this.setBucketVersioning(bucketName, status, null);
    }

    public Mono<Void> setBucketVersioning(String bucketName, VersioningConfiguration.Status status, Boolean mfaDelete) {
        return this.setBucketVersioning(bucketName, new VersioningConfiguration(status, mfaDelete));
    }

    public Mono<Void> setBucketVersioning(String bucketName, VersioningConfiguration versioningConfiguration) {
        return this.setBucketVersioning((SetBucketVersioningArgs)((SetBucketVersioningArgs.Builder)SetBucketVersioningArgs.builder().bucket(bucketName)).config(versioningConfiguration).build());
    }

    public Mono<Void> setBucketVersioning(String bucketName, String region, VersioningConfiguration.Status status) {
        return this.setBucketVersioning(bucketName, region, status, null);
    }

    public Mono<Void> setBucketVersioning(String bucketName, String region, VersioningConfiguration.Status status, Boolean mfaDelete) {
        return this.setBucketVersioning(bucketName, region, new VersioningConfiguration(status, mfaDelete));
    }

    public Mono<Void> setBucketVersioning(String bucketName, String region, VersioningConfiguration versioningConfiguration) {
        return this.setBucketVersioning((SetBucketVersioningArgs)((SetBucketVersioningArgs.Builder)((SetBucketVersioningArgs.Builder)SetBucketVersioningArgs.builder().bucket(bucketName)).region(region)).config(versioningConfiguration).build());
    }

    public Mono<Void> setBucketVersioning(SetBucketVersioningArgs setBucketVersioningArgs) {
        return this.fromFuture("setBucketVersioning", client -> client.setBucketVersioning(setBucketVersioningArgs));
    }

    public Mono<VersioningConfiguration> getBucketVersioning(String bucketName) {
        return this.getBucketVersioning((GetBucketVersioningArgs)((GetBucketVersioningArgs.Builder)GetBucketVersioningArgs.builder().bucket(bucketName)).build());
    }

    public Mono<VersioningConfiguration> getBucketVersioning(String bucketName, String region) {
        return this.getBucketVersioning((GetBucketVersioningArgs)((GetBucketVersioningArgs.Builder)((GetBucketVersioningArgs.Builder)GetBucketVersioningArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<VersioningConfiguration> getBucketVersioning(GetBucketVersioningArgs getBucketVersioningArgs) {
        return this.fromFuture("getBucketVersioning", client -> client.getBucketVersioning(getBucketVersioningArgs));
    }
}

