/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.core.minio.enums.PolicyEnums;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import com.google.common.base.Enums;
import io.minio.DeleteBucketPolicyArgs;
import io.minio.GetBucketPolicyArgs;
import io.minio.SetBucketPolicyArgs;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketPolicyService
extends BaseMinioAsyncService {
    public MinioBucketPolicyService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<PolicyEnums> getBucketPolicy(String bucketName) {
        return this.getBucketPolicy(bucketName, null);
    }

    public Mono<PolicyEnums> getBucketPolicy(String bucketName, String region) {
        return this.getBucketPolicy((GetBucketPolicyArgs)((GetBucketPolicyArgs.Builder)((GetBucketPolicyArgs.Builder)GetBucketPolicyArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<PolicyEnums> getBucketPolicy(GetBucketPolicyArgs getBucketPolicyArgs) {
        return this.fromFuture("getBucketPolicy", client -> client.getBucketPolicy(getBucketPolicyArgs)).flatMap(policy -> Mono.just((Object)((PolicyEnums)Enums.getIfPresent(PolicyEnums.class, (String)policy).or((Object)PolicyEnums.PRIVATE))));
    }

    public Mono<Void> setBucketPolicy(String bucketName, String config) {
        return this.setBucketPolicy(bucketName, null, config);
    }

    public Mono<Void> setBucketPolicy(String bucketName, String region, String config) {
        return this.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).region(region)).config(config).build());
    }

    public Mono<Void> setBucketPolicy(SetBucketPolicyArgs setBucketPolicyArgs) {
        return this.fromFuture("setBucketPolicy", client -> client.setBucketPolicy(setBucketPolicyArgs));
    }

    public Mono<Void> deleteBucketPolicy(String bucketName) {
        return this.deleteBucketPolicy(bucketName, null);
    }

    public Mono<Void> deleteBucketPolicy(String bucketName, String region) {
        return this.deleteBucketPolicy((DeleteBucketPolicyArgs)((DeleteBucketPolicyArgs.Builder)((DeleteBucketPolicyArgs.Builder)DeleteBucketPolicyArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> deleteBucketPolicy(DeleteBucketPolicyArgs deleteBucketPolicyArgs) {
        return this.fromFuture("deleteBucketPolicy", client -> client.deleteBucketPolicy(deleteBucketPolicyArgs));
    }
}

