/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.SetBucketNotificationArgs;
import io.minio.messages.NotificationConfiguration;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketNotificationService
extends BaseMinioAsyncService {
    public MinioBucketNotificationService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<Void> setBucketNotification(String bucketName, NotificationConfiguration notificationConfiguration) {
        return this.setBucketNotification((SetBucketNotificationArgs)((SetBucketNotificationArgs.Builder)SetBucketNotificationArgs.builder().bucket(bucketName)).config(notificationConfiguration).build());
    }

    public Mono<Void> setBucketNotification(String bucketName, String region, NotificationConfiguration notificationConfiguration) {
        return this.setBucketNotification((SetBucketNotificationArgs)((SetBucketNotificationArgs.Builder)((SetBucketNotificationArgs.Builder)SetBucketNotificationArgs.builder().bucket(bucketName)).region(region)).config(notificationConfiguration).build());
    }

    public Mono<Void> setBucketNotification(SetBucketNotificationArgs setBucketNotificationArgs) {
        return this.fromFuture("setBucketNotification", client -> client.setBucketNotification(setBucketNotificationArgs));
    }

    public Mono<NotificationConfiguration> getBucketNotification(String bucketName) {
        return this.getBucketNotification((GetBucketNotificationArgs)((GetBucketNotificationArgs.Builder)GetBucketNotificationArgs.builder().bucket(bucketName)).build());
    }

    public Mono<NotificationConfiguration> getBucketNotification(String bucketName, String region) {
        return this.getBucketNotification((GetBucketNotificationArgs)((GetBucketNotificationArgs.Builder)((GetBucketNotificationArgs.Builder)GetBucketNotificationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<NotificationConfiguration> getBucketNotification(GetBucketNotificationArgs getBucketNotificationArgs) {
        return this.fromFuture("getBucketNotification", client -> client.getBucketNotification(getBucketNotificationArgs));
    }

    public Mono<Void> deleteBucketNotification(String bucketName) {
        return this.deleteBucketNotification((DeleteBucketNotificationArgs)((DeleteBucketNotificationArgs.Builder)DeleteBucketNotificationArgs.builder().bucket(bucketName)).build());
    }

    public Mono<Void> deleteBucketNotification(String bucketName, String region) {
        return this.deleteBucketNotification((DeleteBucketNotificationArgs)((DeleteBucketNotificationArgs.Builder)((DeleteBucketNotificationArgs.Builder)DeleteBucketNotificationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> deleteBucketNotification(DeleteBucketNotificationArgs deleteBucketNotificationArgs) {
        return this.fromFuture("deleteBucketNotification", client -> client.deleteBucketNotification(deleteBucketNotificationArgs));
    }
}

