/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.DeleteBucketLifecycleArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.SetBucketLifecycleArgs;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.LifecycleRule;
import java.util.List;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketLifecycleService
extends BaseMinioAsyncService {
    public MinioBucketLifecycleService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<Void> setBucketLifecycle(String bucketName, List<LifecycleRule> lifecycleRules) {
        return this.setBucketLifecycle(bucketName, new LifecycleConfiguration(lifecycleRules));
    }

    public Mono<Void> setBucketLifecycle(String bucketName, String region, List<LifecycleRule> lifecycleRules) {
        return this.setBucketLifecycle(bucketName, region, new LifecycleConfiguration(lifecycleRules));
    }

    public Mono<Void> setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfiguration) {
        return this.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketName)).config(lifecycleConfiguration).build());
    }

    public Mono<Void> setBucketLifecycle(String bucketName, String region, LifecycleConfiguration lifecycleConfiguration) {
        return this.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketName)).region(region)).config(lifecycleConfiguration).build());
    }

    public Mono<Void> setBucketLifecycle(SetBucketLifecycleArgs setBucketLifecycleArgs) {
        return this.fromFuture("setBucketLifecycle", client -> client.setBucketLifecycle(setBucketLifecycleArgs));
    }

    public Mono<LifecycleConfiguration> getBucketLifecycle(String bucketName) {
        return this.getBucketLifecycle((GetBucketLifecycleArgs)((GetBucketLifecycleArgs.Builder)GetBucketLifecycleArgs.builder().bucket(bucketName)).build());
    }

    public Mono<LifecycleConfiguration> getBucketLifecycle(String bucketName, String region) {
        return this.getBucketLifecycle((GetBucketLifecycleArgs)((GetBucketLifecycleArgs.Builder)((GetBucketLifecycleArgs.Builder)GetBucketLifecycleArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<LifecycleConfiguration> getBucketLifecycle(GetBucketLifecycleArgs getBucketLifecycleArgs) {
        return this.fromFuture("getBucketLifecycle", client -> client.getBucketLifecycle(getBucketLifecycleArgs));
    }

    public Mono<Void> deleteBucketLifecycle(String bucketName) {
        return this.deleteBucketLifecycle((DeleteBucketLifecycleArgs)((DeleteBucketLifecycleArgs.Builder)DeleteBucketLifecycleArgs.builder().bucket(bucketName)).build());
    }

    public Mono<Void> deleteBucketLifecycle(String bucketName, String region) {
        return this.deleteBucketLifecycle((DeleteBucketLifecycleArgs)((DeleteBucketLifecycleArgs.Builder)((DeleteBucketLifecycleArgs.Builder)DeleteBucketLifecycleArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> deleteBucketLifecycle(DeleteBucketLifecycleArgs deleteBucketLifecycleArgs) {
        return this.fromFuture("deleteBucketLifecycle", client -> client.deleteBucketLifecycle(deleteBucketLifecycleArgs));
    }
}

