/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.DeleteBucketEncryptionArgs;
import io.minio.GetBucketEncryptionArgs;
import io.minio.SetBucketEncryptionArgs;
import io.minio.messages.SseConfiguration;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketEncryptionService
extends BaseMinioAsyncService {
    public MinioBucketEncryptionService(MinioAsyncClientObjectPool minioAsyncClientObjectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)minioAsyncClientObjectPool);
    }

    public Mono<SseConfiguration> getBucketEncryption(String bucketName) {
        return this.getBucketEncryption(bucketName, null);
    }

    public Mono<SseConfiguration> getBucketEncryption(String bucketName, String region) {
        return this.getBucketEncryption((GetBucketEncryptionArgs)((GetBucketEncryptionArgs.Builder)((GetBucketEncryptionArgs.Builder)GetBucketEncryptionArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<SseConfiguration> getBucketEncryption(GetBucketEncryptionArgs getBucketEncryptionArgs) {
        return this.fromFuture("getBucketEncryption", client -> client.getBucketEncryption(getBucketEncryptionArgs));
    }

    public Mono<Void> setBucketEncryption(String bucketName, SseConfiguration config) {
        return this.setBucketEncryption(bucketName, null, config);
    }

    public Mono<Void> setBucketEncryption(String bucketName, String region, SseConfiguration config) {
        return this.setBucketEncryption((SetBucketEncryptionArgs)((SetBucketEncryptionArgs.Builder)((SetBucketEncryptionArgs.Builder)SetBucketEncryptionArgs.builder().bucket(bucketName)).region(region)).config(config).build());
    }

    public Mono<Void> setBucketEncryption(SetBucketEncryptionArgs setBucketEncryptionArgs) {
        return this.fromFuture("setBucketEncryption", client -> client.setBucketEncryption(setBucketEncryptionArgs));
    }

    public Mono<Void> deleteBucketEncryption(String bucketName) {
        return this.deleteBucketEncryption(bucketName, null);
    }

    public Mono<Void> deleteBucketEncryption(String bucketName, String region) {
        return this.deleteBucketEncryption((DeleteBucketEncryptionArgs)((DeleteBucketEncryptionArgs.Builder)((DeleteBucketEncryptionArgs.Builder)DeleteBucketEncryptionArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> deleteBucketEncryption(DeleteBucketEncryptionArgs deleteBucketEncryptionArgs) {
        return this.fromFuture("deleteBucketEncryption", client -> client.deleteBucketEncryption(deleteBucketEncryptionArgs));
    }
}

