/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAdminService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.admin.GroupInfo;
import io.minio.admin.MinioAdminClient;
import io.minio.admin.Status;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioAdminGroupService
extends BaseMinioAdminService {
    public MinioAdminGroupService(MinioAdminClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAdminClient>)objectPool);
    }

    public Mono<List<String>> listGroups() {
        return this.just("listGroups", MinioAdminClient::listGroups);
    }

    public Mono<GroupInfo> getGroupInfo(String group) {
        return this.just("getGroupInfo", client -> client.getGroupInfo(group));
    }

    public Mono<Void> addUpdateGroup(@Nonnull String group, @Nullable Status groupStatus, @Nullable List<String> members) {
        return this.empty("addUpdateGroup", client -> client.addUpdateGroup(group, groupStatus, members));
    }

    public Mono<Void> removeGroup(@Nonnull String group) {
        return this.empty("removeGroup", client -> client.removeGroup(group));
    }
}

