/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.definition.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssErrorResponseException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInsufficientDataException;
import cn.herodotus.oss.dialect.core.exception.OssInternalException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidResponseException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.exception.OssXmlParserException;
import cn.herodotus.oss.dialect.core.service.BaseOssService;
import cn.herodotus.oss.dialect.reactive.minio.definition.function.MinioAsyncFunction;
import cn.herodotus.oss.dialect.reactive.minio.definition.function.MinioSyncFunction;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class BaseMinioAsyncService
extends BaseOssService<MinioAsyncClient> {
    private static final Logger log = LoggerFactory.getLogger(BaseMinioAsyncService.class);

    public BaseMinioAsyncService(AbstractObjectPool<MinioAsyncClient> objectPool) {
        super(objectPool);
    }

    private <T> CompletableFuture<T> template(String name, MinioAsyncFunction<MinioAsyncClient, CompletableFuture<T>> operate) {
        MinioAsyncClient client = (MinioAsyncClient)this.getClient();
        try {
            CompletableFuture<T> completableFuture = operate.apply(client);
            return completableFuture;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)name, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)name, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)name, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)name, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in in [{}].", (Object)name, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    protected <T> Mono<T> fromFuture(String name, MinioAsyncFunction<MinioAsyncClient, CompletableFuture<T>> operate) {
        return Mono.fromFuture(this.template(name, operate));
    }

    private <T> T template(String name, MinioSyncFunction<MinioAsyncClient, T> operate) {
        MinioAsyncClient client = (MinioAsyncClient)this.getClient();
        try {
            T t = operate.apply(client);
            return t;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)name, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)name, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)name, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)name, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)name, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)name, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)name, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    protected <T> Mono<T> just(String name, MinioSyncFunction<MinioAsyncClient, T> operate) {
        return Mono.just(this.template(name, operate));
    }

    protected void template(Consumer<MinioAsyncClient> operate) {
        MinioAsyncClient client = (MinioAsyncClient)this.getClient();
        operate.accept(client);
        this.close(client);
    }

    protected Multimap<String, String> toMultimap(Map<String, String> map) {
        HashMultimap multimap = HashMultimap.create();
        if (map != null) {
            multimap.putAll((Multimap)Multimaps.forMap(map));
        }
        return Multimaps.unmodifiableMultimap((Multimap)multimap);
    }
}

