/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.definition.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidCipherTextException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.core.service.BaseOssService;
import cn.herodotus.oss.dialect.reactive.minio.definition.function.MinioAdminConsumer;
import cn.herodotus.oss.dialect.reactive.minio.definition.function.MinioAdminFunction;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.admin.MinioAdminClient;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class BaseMinioAdminService
extends BaseOssService<MinioAdminClient> {
    private static final Logger log = LoggerFactory.getLogger(BaseMinioAdminService.class);

    public BaseMinioAdminService(AbstractObjectPool<MinioAdminClient> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    private <T> T template(String name, MinioAdminFunction<MinioAdminClient, T> action) {
        MinioAdminClient client = (MinioAdminClient)this.getClient();
        try {
            T t = action.apply(client);
            return t;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)name, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            log.error("[Herodotus] |- Minio catch InvalidCipherTextException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidCipherTextException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)name, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    private void template(String name, MinioAdminConsumer<MinioAdminClient> action) {
        MinioAdminClient client = (MinioAdminClient)this.getClient();
        try {
            action.accept(client);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)name, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            log.error("[Herodotus] |- Minio catch InvalidCipherTextException in [{}].", (Object)name, (Object)e);
            throw new OssInvalidCipherTextException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)name, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    protected <T> Mono<T> just(String function, MinioAdminFunction<MinioAdminClient, T> action) {
        return Mono.just(this.template(function, action));
    }

    protected Mono<Void> empty(String function, MinioAdminConsumer<MinioAdminClient> action) {
        this.template(function, action);
        return Mono.empty();
    }
}

