/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.config;

import cn.herodotus.oss.core.minio.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.core.minio.definition.pool.MinioAdminClientPooledObjectFactory;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientPooledObjectFactory;
import cn.herodotus.oss.core.minio.properties.MinioProperties;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientPooledObjectFactory;
import cn.herodotus.stirrup.core.foundation.annotation.ConditionalOnReactiveApplication;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnReactiveApplication
@EnableConfigurationProperties(value={MinioProperties.class})
public class OssDialectMinioReactiveConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OssDialectMinioReactiveConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Oss Dialect Minio Reactive] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioAsyncClientObjectPool minioAsyncClientObjectPool(MinioProperties minioProperties) {
        MinioAsyncClientPooledObjectFactory factory = new MinioAsyncClientPooledObjectFactory(minioProperties);
        MinioAsyncClientObjectPool pool = new MinioAsyncClientObjectPool((AbstractOssClientPooledObjectFactory)factory);
        log.trace("[Herodotus] |- Bean [Minio Async Client Pool] Configure.");
        return pool;
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioAdminClientObjectPool minioAdminClientObjectPool(MinioProperties minioProperties) {
        MinioAdminClientPooledObjectFactory factory = new MinioAdminClientPooledObjectFactory(minioProperties);
        MinioAdminClientObjectPool pool = new MinioAdminClientObjectPool((AbstractOssClientPooledObjectFactory)factory);
        log.trace("[Herodotus] |- Bean [Minio Admin Client Pool] Configure.");
        return pool;
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackages={"cn.herodotus.oss.dialect.reactive.minio.service"})
    static class OssDialectMinioReactiveServiceConfiguration {
        OssDialectMinioReactiveServiceConfiguration() {
        }
    }
}

