/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.domain.object.DeleteObjectDomain;
import cn.herodotus.oss.core.domain.object.ListObjectsDomain;
import cn.herodotus.oss.core.minio.converter.domain.IterableResultItemToDomainConverter;
import cn.herodotus.oss.core.minio.converter.domain.ResultDeleteErrorToDomainConverter;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.core.minio.utils.MinioConverterUtils;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.ComposeObjectArgs;
import io.minio.CopyObjectArgs;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.ObjectWriteResponse;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.RestoreObjectArgs;
import io.minio.SelectObjectContentArgs;
import io.minio.SelectResponseStream;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.http.Method;
import io.minio.messages.DeleteObject;
import io.minio.messages.Retention;
import io.minio.messages.Tags;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioObjectService
extends BaseMinioAsyncService {
    public MinioObjectService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName) {
        return this.listObjects(bucketName, null);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String prefix) {
        return this.listObjects(bucketName, null, prefix);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix) {
        return this.listObjects(bucketName, region, prefix, null);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter) {
        return this.listObjects(bucketName, region, prefix, delimiter, false);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter, boolean recursive) {
        return this.listObjects(bucketName, region, prefix, delimiter, recursive, null);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter, boolean recursive, String keyMarker) {
        return this.listObjects(bucketName, region, prefix, delimiter, recursive, true, keyMarker);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker) {
        return this.listObjects(bucketName, region, prefix, delimiter, recursive, useUrlEncodingType, keyMarker, 1000);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys) {
        return this.listObjects(bucketName, region, prefix, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, false);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, boolean includeVersions) {
        return this.listObjects(bucketName, region, prefix, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, includeVersions, null);
    }

    public Mono<ListObjectsDomain> listObjects(String bucketName, String region, String prefix, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, boolean includeVersions, String versionIdMarker) {
        return this.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).region(region)).delimiter(delimiter).recursive(recursive).useUrlEncodingType(useUrlEncodingType).keyMarker(keyMarker).maxKeys(maxKeys).prefix(prefix).includeVersions(includeVersions).versionIdMarker(versionIdMarker).useApiVersion1(true).build());
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName) {
        return this.listObjectsV2(bucketName, null);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region) {
        return this.listObjectsV2(bucketName, region, null);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter) {
        return this.listObjectsV2(bucketName, region, delimiter, false);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, null);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, String keyMarker) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, true, keyMarker);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, 1000);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, null);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, prefix, false);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix, boolean includeVersions) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, prefix, includeVersions, null);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix, boolean includeVersions, String versionIdMarker) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, prefix, includeVersions, versionIdMarker, null);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix, boolean includeVersions, String versionIdMarker, String continuationToken) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, prefix, includeVersions, versionIdMarker, continuationToken, false);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix, boolean includeVersions, String versionIdMarker, String continuationToken, boolean fetchOwner) {
        return this.listObjectsV2(bucketName, region, delimiter, recursive, useUrlEncodingType, keyMarker, maxKeys, prefix, includeVersions, versionIdMarker, continuationToken, fetchOwner, false);
    }

    public Mono<ListObjectsDomain> listObjectsV2(String bucketName, String region, String delimiter, boolean recursive, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix, boolean includeVersions, String versionIdMarker, String continuationToken, boolean fetchOwner, boolean includeUserMetadata) {
        return this.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).region(region)).delimiter(delimiter).recursive(recursive).useUrlEncodingType(useUrlEncodingType).keyMarker(keyMarker).maxKeys(maxKeys).prefix(prefix).includeVersions(includeVersions).versionIdMarker(versionIdMarker).useApiVersion1(false).continuationToken(continuationToken).fetchOwner(fetchOwner).includeUserMetadata(includeUserMetadata).build());
    }

    public Mono<ListObjectsDomain> listObjects(ListObjectsArgs listObjectsArgs) {
        IterableResultItemToDomainConverter toDomain = new IterableResultItemToDomainConverter(listObjectsArgs.bucket(), listObjectsArgs.prefix());
        return this.just("listObjects", client -> client.listObjects(listObjectsArgs)).mapNotNull(arg_0 -> ((Converter)toDomain).convert(arg_0));
    }

    public Mono<List<DeleteObjectDomain>> removeObjects(String bucketName, Iterable<DeleteObject> objects) {
        return this.removeObjects(bucketName, null, objects);
    }

    public Mono<List<DeleteObjectDomain>> removeObjects(String bucketName, String region, Iterable<DeleteObject> objects) {
        return this.removeObjects(bucketName, region, objects, false);
    }

    public Mono<List<DeleteObjectDomain>> removeObjects(String bucketName, String region, Iterable<DeleteObject> objects, boolean bypassGovernanceMode) {
        return this.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).region(region)).objects(objects).bypassGovernanceMode(bypassGovernanceMode).build());
    }

    public Mono<List<DeleteObjectDomain>> removeObjects(RemoveObjectsArgs removeObjectsArgs) {
        return this.just("removeObject", client -> client.removeObjects(removeObjectsArgs)).map(items -> MinioConverterUtils.toDomains((Iterable)items, (Converter)new ResultDeleteErrorToDomainConverter()));
    }

    public Mono<Void> removeObject(String bucketName, String objectName) {
        return this.removeObject(bucketName, null, objectName);
    }

    public Mono<Void> removeObject(String bucketName, String region, String objectName) {
        return this.removeObject(bucketName, region, objectName, null);
    }

    public Mono<Void> removeObject(String bucketName, String region, String objectName, String versionId) {
        return this.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).region(region)).object(objectName)).versionId(versionId)).build());
    }

    public Mono<Void> removeObject(RemoveObjectArgs removeObjectArgs) {
        return this.fromFuture("removeObject", client -> client.removeObject(removeObjectArgs));
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String objectName) {
        return this.statObject(bucketName, null, objectName);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName) {
        return this.statObject(bucketName, region, objectName, null);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, String matchETag) {
        return this.statObject(bucketName, region, objectName, matchETag, null);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, String matchETag, String notMatchETag) {
        return this.statObject(bucketName, region, objectName, matchETag, notMatchETag, null);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, String matchETag, String notMatchETag, ZonedDateTime modifiedSince) {
        return this.statObject(bucketName, region, objectName, matchETag, notMatchETag, modifiedSince, null);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince) {
        return this.statObject(bucketName, region, objectName, null, null, matchETag, notMatchETag, modifiedSince, unmodifiedSince);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, Long offset, Long length, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince) {
        return this.statObject(bucketName, region, objectName, offset, length, matchETag, notMatchETag, modifiedSince, unmodifiedSince, null);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, Long offset, Long length, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince, ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
        return this.statObject(bucketName, region, objectName, offset, length, matchETag, notMatchETag, modifiedSince, unmodifiedSince, serverSideEncryptionCustomerKey, null);
    }

    public Mono<StatObjectResponse> statObject(String bucketName, String region, String objectName, Long offset, Long length, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince, ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey, String versionId) {
        return this.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).region(region)).object(objectName)).offset(offset)).length(length)).matchETag(matchETag)).notMatchETag(notMatchETag)).modifiedSince(modifiedSince)).unmodifiedSince(unmodifiedSince)).ssec(serverSideEncryptionCustomerKey)).versionId(versionId)).build());
    }

    public Mono<StatObjectResponse> statObject(StatObjectArgs statObjectArgs) {
        return this.fromFuture("statObject", client -> client.statObject(statObjectArgs));
    }

    public Mono<ObjectWriteResponse> composeObject(ComposeObjectArgs composeObjectArgs) {
        return this.fromFuture("composeObject", client -> client.composeObject(composeObjectArgs));
    }

    public Mono<ObjectWriteResponse> copyObject(CopyObjectArgs copyObjectArgs) {
        return this.fromFuture("copyObject", client -> client.copyObject(copyObjectArgs));
    }

    public Mono<Void> restoreObject(RestoreObjectArgs args) {
        return this.fromFuture("restoreObject", client -> client.restoreObject(args));
    }

    public Mono<SelectResponseStream> selectObjectContent(SelectObjectContentArgs selectObjectContentArgs) {
        return this.just("selectObjectContent", client -> client.selectObjectContent(selectObjectContentArgs));
    }

    public Mono<Map<String, String>> getPreSignedPostFormData(PostPolicy postPolicy) {
        return this.just("getPreSignedPostFormData", client -> client.getPresignedPostFormData(postPolicy));
    }

    public Mono<String> getPreSignedObjectUrl(String bucketName, String objectName) {
        return this.getPreSignedObjectUrl(bucketName, null, objectName);
    }

    public Mono<String> getPreSignedObjectUrl(String bucketName, String region, String objectName) {
        return this.getPreSignedObjectUrl(bucketName, region, objectName, Method.GET);
    }

    public Mono<String> getPreSignedObjectUrl(String bucketName, String region, String objectName, Method method) {
        return this.getPreSignedObjectUrl(bucketName, region, objectName, method, 7, TimeUnit.DAYS);
    }

    public Mono<String> getPreSignedObjectUrl(String bucketName, String region, String objectName, Method method, int duration, TimeUnit unit) {
        return this.getPreSignedObjectUrl(bucketName, region, objectName, method, duration, unit, null);
    }

    public Mono<String> getPreSignedObjectUrl(String bucketName, String region, String objectName, Method method, int duration, TimeUnit unit, String versionId) {
        return this.getPreSignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).region(region)).object(objectName)).method(method).expiry(duration, unit).versionId(versionId)).build());
    }

    public Mono<String> getPreSignedObjectUrl(GetPresignedObjectUrlArgs args) {
        return this.just("getPreSignedObjectUrl", client -> client.getPresignedObjectUrl(args));
    }

    public Mono<Void> downloadObject(String bucketName, String objectName, String fileName) {
        return this.downloadObject(bucketName, objectName, fileName, false);
    }

    public Mono<Void> downloadObject(String bucketName, String objectName, String fileName, boolean overwrite) {
        return this.downloadObject(bucketName, null, objectName, fileName, overwrite);
    }

    public Mono<Void> downloadObject(String bucketName, String region, String objectName, String fileName, boolean overwrite) {
        return this.downloadObject(bucketName, region, objectName, fileName, overwrite, null);
    }

    public Mono<Void> downloadObject(String bucketName, String region, String objectName, String fileName, boolean overwrite, ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
        return this.downloadObject(bucketName, region, objectName, fileName, overwrite, serverSideEncryptionCustomerKey, null);
    }

    public Mono<Void> downloadObject(String bucketName, String region, String objectName, String fileName, boolean overwrite, ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey, String versionId) {
        return this.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).region(region)).object(objectName)).filename(fileName).overwrite(overwrite).ssec(serverSideEncryptionCustomerKey)).versionId(versionId)).build());
    }

    public Mono<Void> downloadObject(DownloadObjectArgs downloadObjectArgs) {
        return this.fromFuture("downloadObject", client -> client.downloadObject(downloadObjectArgs));
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String objectName, String fileName) throws IOException {
        return this.uploadObject(bucketName, null, objectName, fileName);
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String region, String objectName, String fileName) throws IOException {
        return this.uploadObject(bucketName, region, objectName, fileName, null);
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String region, String objectName, String fileName, String contentType) throws IOException {
        return this.uploadObject(bucketName, region, objectName, fileName, contentType, false);
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String region, String objectName, String fileName, String contentType, boolean legalHold) throws IOException {
        return this.uploadObject(bucketName, region, objectName, fileName, contentType, legalHold, null);
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String region, String objectName, String fileName, String contentType, boolean legalHold, Retention retention) throws IOException {
        return this.uploadObject(bucketName, region, objectName, fileName, contentType, legalHold, retention, null);
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String region, String objectName, String fileName, String contentType, boolean legalHold, Retention retention, Tags tags) throws IOException {
        return this.uploadObject(bucketName, region, objectName, fileName, contentType, legalHold, retention, tags, null);
    }

    public Mono<ObjectWriteResponse> uploadObject(String bucketName, String region, String objectName, String fileName, String contentType, boolean legalHold, Retention retention, Tags tags, ServerSideEncryption sse) throws IOException {
        return this.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).region(region)).object(objectName)).filename(fileName).contentType(contentType).sse(sse)).legalHold(legalHold)).tags(tags)).retention(retention)).build());
    }

    public Mono<ObjectWriteResponse> uploadObject(UploadObjectArgs uploadObjectArgs) {
        return this.fromFuture("uploadObject", client -> client.uploadObject(uploadObjectArgs));
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String objectName) {
        return this.getObject(bucketName, null, objectName);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName) {
        return this.getObject(bucketName, region, objectName, null);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, String matchETag) {
        return this.getObject(bucketName, region, objectName, matchETag, null);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, String matchETag, String notMatchETag) {
        return this.getObject(bucketName, region, objectName, matchETag, notMatchETag, null);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, String matchETag, String notMatchETag, ZonedDateTime modifiedSince) {
        return this.getObject(bucketName, region, objectName, matchETag, notMatchETag, modifiedSince, null);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince) {
        return this.getObject(bucketName, region, objectName, null, null, matchETag, notMatchETag, modifiedSince, unmodifiedSince);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, Long offset, Long length, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince) {
        return this.getObject(bucketName, region, objectName, offset, length, matchETag, notMatchETag, modifiedSince, unmodifiedSince, null);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, Long offset, Long length, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince, ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
        return this.getObject(bucketName, region, objectName, offset, length, matchETag, notMatchETag, modifiedSince, unmodifiedSince, serverSideEncryptionCustomerKey, null);
    }

    public Mono<GetObjectResponse> getObject(String bucketName, String region, String objectName, Long offset, Long length, String matchETag, String notMatchETag, ZonedDateTime modifiedSince, ZonedDateTime unmodifiedSince, ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey, String versionId) {
        return this.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).region(region)).object(objectName)).offset(offset)).length(length)).matchETag(matchETag)).notMatchETag(notMatchETag)).modifiedSince(modifiedSince)).unmodifiedSince(unmodifiedSince)).ssec(serverSideEncryptionCustomerKey)).versionId(versionId)).build());
    }

    public Mono<GetObjectResponse> getObject(GetObjectArgs getObjectArgs) {
        return this.fromFuture("getObject", client -> client.getObject(getObjectArgs));
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String objectName, InputStream stream, long objectSize, String contentType) {
        return this.putObject(bucketName, null, objectName, stream, objectSize, -1L, contentType);
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String objectName, InputStream stream, long objectSize, long partSize, String contentType) {
        return this.putObject(bucketName, null, objectName, stream, objectSize, partSize, contentType);
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String region, String objectName, InputStream stream, long objectSize, long partSize, String contentType) {
        return this.putObject(bucketName, region, objectName, stream, objectSize, partSize, contentType, false);
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String region, String objectName, InputStream stream, long objectSize, long partSize, String contentType, boolean legalHold) {
        return this.putObject(bucketName, region, objectName, stream, objectSize, partSize, contentType, legalHold, null);
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String region, String objectName, InputStream stream, long objectSize, long partSize, String contentType, boolean legalHold, Retention retention) {
        return this.putObject(bucketName, region, objectName, stream, objectSize, partSize, contentType, legalHold, retention, null);
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String region, String objectName, InputStream stream, long objectSize, long partSize, String contentType, boolean legalHold, Retention retention, Tags tags) {
        return this.putObject(bucketName, region, objectName, stream, objectSize, partSize, contentType, legalHold, retention, tags, null);
    }

    public Mono<ObjectWriteResponse> putObject(String bucketName, String region, String objectName, InputStream stream, long objectSize, long partSize, String contentType, boolean legalHold, Retention retention, Tags tags, ServerSideEncryption sse) {
        return this.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).region(region)).object(objectName)).stream(stream, objectSize, partSize).contentType(contentType).sse(sse)).legalHold(legalHold)).tags(tags)).retention(retention)).build());
    }

    public Mono<ObjectWriteResponse> putObject(PutObjectArgs putObjectArgs) {
        return this.fromFuture("putObject", client -> client.putObject(putObjectArgs));
    }
}

