/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.converter.retention.RetentionToDomainConverter;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.core.minio.domain.RetentionDomain;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.GetObjectRetentionArgs;
import io.minio.SetObjectRetentionArgs;
import io.minio.messages.Retention;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioObjectRetentionService
extends BaseMinioAsyncService {
    private final Converter<Retention, RetentionDomain> toDo = new RetentionToDomainConverter();

    public MinioObjectRetentionService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<RetentionDomain> getObjectRetention(String bucketName, String objectName) {
        return this.getObjectRetention(bucketName, null, objectName);
    }

    public Mono<RetentionDomain> getObjectRetention(String bucketName, String region, String objectName) {
        return this.getObjectRetention(bucketName, region, objectName, null);
    }

    public Mono<RetentionDomain> getObjectRetention(String bucketName, String region, String objectName, String versionId) {
        return this.getObjectRetention((GetObjectRetentionArgs)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)GetObjectRetentionArgs.builder().bucket(bucketName)).region(region)).object(objectName)).versionId(versionId)).build());
    }

    public Mono<RetentionDomain> getObjectRetention(GetObjectRetentionArgs getObjectRetentionArgs) {
        return this.fromFuture("getObjectRetention", client -> client.getObjectRetention(getObjectRetentionArgs)).flatMap(retention -> Mono.justOrEmpty((Object)((RetentionDomain)this.toDo.convert(retention))));
    }

    public Mono<Void> setObjectRetention(String bucketName, String objectName, Retention config) {
        return this.setObjectRetention(bucketName, objectName, config, false);
    }

    public Mono<Void> setObjectRetention(String bucketName, String objectName, Retention config, boolean bypassGovernanceMode) {
        return this.setObjectRetention(bucketName, null, objectName, config, bypassGovernanceMode);
    }

    public Mono<Void> setObjectRetention(String bucketName, String region, String objectName, Retention config, boolean bypassGovernanceMode) {
        return this.setObjectRetention(bucketName, region, objectName, config, bypassGovernanceMode, null);
    }

    public Mono<Void> setObjectRetention(String bucketName, String region, String objectName, Retention config, boolean bypassGovernanceMode, String versionId) {
        return this.setObjectRetention((SetObjectRetentionArgs)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)SetObjectRetentionArgs.builder().bucket(bucketName)).region(region)).object(objectName)).config(config).bypassGovernanceMode(bypassGovernanceMode).versionId(versionId)).build());
    }

    public Mono<Void> setObjectRetention(SetObjectRetentionArgs setObjectRetentionArgs) {
        return this.fromFuture("setObjectRetention", client -> client.setObjectRetention(setObjectRetentionArgs));
    }
}

