/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.DeleteObjectLockConfigurationArgs;
import io.minio.GetObjectLockConfigurationArgs;
import io.minio.SetObjectLockConfigurationArgs;
import io.minio.messages.ObjectLockConfiguration;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioObjectLockConfigurationService
extends BaseMinioAsyncService {
    public MinioObjectLockConfigurationService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<ObjectLockConfiguration> getObjectLockConfiguration(String bucketName) {
        return this.getObjectLockConfiguration(bucketName, null);
    }

    public Mono<ObjectLockConfiguration> getObjectLockConfiguration(String bucketName, String region) {
        return this.getObjectLockConfiguration((GetObjectLockConfigurationArgs)((GetObjectLockConfigurationArgs.Builder)((GetObjectLockConfigurationArgs.Builder)GetObjectLockConfigurationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<ObjectLockConfiguration> getObjectLockConfiguration(GetObjectLockConfigurationArgs getObjectLockConfigurationArgs) {
        return this.fromFuture("getObjectLockConfiguration", client -> client.getObjectLockConfiguration(getObjectLockConfigurationArgs));
    }

    public Mono<Void> setObjectLockConfiguration(String bucketName, ObjectLockConfiguration config) {
        return this.setObjectLockConfiguration(bucketName, null, config);
    }

    public Mono<Void> setObjectLockConfiguration(String bucketName, String region, ObjectLockConfiguration config) {
        return this.setObjectLockConfiguration((SetObjectLockConfigurationArgs)((SetObjectLockConfigurationArgs.Builder)((SetObjectLockConfigurationArgs.Builder)SetObjectLockConfigurationArgs.builder().bucket(bucketName)).region(region)).config(config).build());
    }

    public Mono<Void> setObjectLockConfiguration(SetObjectLockConfigurationArgs setObjectLockConfigurationArgs) {
        return this.fromFuture("setObjectLockConfiguration", client -> client.setObjectLockConfiguration(setObjectLockConfigurationArgs));
    }

    public Mono<Void> deleteObjectLockConfiguration(String bucketName) {
        return this.deleteObjectLockConfiguration(bucketName, null);
    }

    public Mono<Void> deleteObjectLockConfiguration(String bucketName, String region) {
        return this.deleteObjectLockConfiguration((DeleteObjectLockConfigurationArgs)((DeleteObjectLockConfigurationArgs.Builder)((DeleteObjectLockConfigurationArgs.Builder)DeleteObjectLockConfigurationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> deleteObjectLockConfiguration(DeleteObjectLockConfigurationArgs deleteObjectLockConfigurationArgs) {
        return this.fromFuture("deleteObjectLockConfiguration", client -> client.deleteObjectLockConfiguration(deleteObjectLockConfigurationArgs));
    }
}

