/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.DeleteBucketTagsArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.SetBucketTagsArgs;
import io.minio.messages.Tags;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketTagsService
extends BaseMinioAsyncService {
    public MinioBucketTagsService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<Tags> getBucketTags(String bucketName) {
        return this.getBucketTags(bucketName, null);
    }

    public Mono<Tags> getBucketTags(String bucketName, String region) {
        return this.getBucketTags((GetBucketTagsArgs)((GetBucketTagsArgs.Builder)((GetBucketTagsArgs.Builder)GetBucketTagsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Tags> getBucketTags(GetBucketTagsArgs getBucketTagsArgs) {
        return this.fromFuture("getBucketTags", client -> client.getBucketTags(getBucketTagsArgs));
    }

    public Mono<Void> setBucketTags(String bucketName, Tags tags) {
        return this.setBucketTags(bucketName, null, tags);
    }

    public Mono<Void> setBucketTags(String bucketName, String region, Tags tags) {
        return this.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketName)).region(region)).tags(tags).build());
    }

    public Mono<Void> setBucketTags(SetBucketTagsArgs setBucketTagsArgs) {
        return this.fromFuture("setBucketTags", client -> client.setBucketTags(setBucketTagsArgs));
    }

    public Mono<Void> deleteBucketTags(String bucketName) {
        return this.deleteBucketTags(bucketName, null);
    }

    public Mono<Void> deleteBucketTags(String bucketName, String region) {
        return this.deleteBucketTags((DeleteBucketTagsArgs)((DeleteBucketTagsArgs.Builder)((DeleteBucketTagsArgs.Builder)DeleteBucketTagsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> deleteBucketTags(DeleteBucketTagsArgs deleteBucketTagsArgs) {
        return this.fromFuture("deleteBucketTags", client -> client.deleteBucketTags(deleteBucketTagsArgs));
    }
}

