/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.domain.bucket.BucketDomain;
import cn.herodotus.oss.core.minio.converter.domain.BucketToDomainConverter;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.core.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.core.utils.ConverterUtils;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAsyncService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.BucketExistsArgs;
import io.minio.ListBucketsArgs;
import io.minio.MakeBucketArgs;
import io.minio.RemoveBucketArgs;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketService
extends BaseMinioAsyncService {
    public MinioBucketService(MinioAsyncClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAsyncClient>)objectPool);
    }

    public Mono<List<BucketDomain>> listBuckets(ListBucketsArgs listBucketsArgs) {
        return this.fromFuture("listBuckets", client -> ObjectUtils.isNotEmpty((Object)listBucketsArgs) ? client.listBuckets(listBucketsArgs) : client.listBuckets()).map(items -> ConverterUtils.toDomains((List)items, (Converter)new BucketToDomainConverter()));
    }

    public Mono<Boolean> bucketExists(String bucketName) {
        return this.bucketExists(bucketName, null);
    }

    public Mono<Boolean> bucketExists(String bucketName, String region) {
        return this.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Boolean> bucketExists(BucketExistsArgs bucketExistsArgs) {
        return this.fromFuture("bucketExists", client -> client.bucketExists(bucketExistsArgs));
    }

    public Mono<Void> makeBucket(String bucketName) {
        return this.makeBucket(bucketName, null);
    }

    public Mono<Void> makeBucket(String bucketName, String region) {
        return this.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> makeBucket(MakeBucketArgs makeBucketArgs) {
        return this.fromFuture("makeBucket", client -> client.makeBucket(makeBucketArgs));
    }

    public Mono<Void> removeBucket(String bucketName) {
        return this.removeBucket(bucketName, null);
    }

    public Mono<Void> removeBucket(String bucketName, String region) {
        return this.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Mono<Void> removeBucket(RemoveBucketArgs removeBucketArgs) {
        return this.fromFuture("removeBucket", client -> client.removeBucket(removeBucketArgs));
    }
}

