/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.reactive.minio.service;

import cn.herodotus.oss.core.minio.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.dialect.reactive.minio.definition.service.BaseMinioAdminService;
import cn.herodotus.stirrup.core.definition.support.AbstractObjectPool;
import io.minio.admin.MinioAdminClient;
import io.minio.admin.QuotaUnit;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MinioBucketQuotaService
extends BaseMinioAdminService {
    public MinioBucketQuotaService(MinioAdminClientObjectPool objectPool) {
        super((AbstractObjectPool<MinioAdminClient>)objectPool);
    }

    public Mono<Void> setBucketQuota(@Nonnull String bucketName, long size, @Nonnull QuotaUnit unit) {
        return this.empty("setBucketQuota", client -> client.setBucketQuota(bucketName, size, unit));
    }

    public Mono<Void> clearBucketQuota(@Nonnull String bucketName) {
        return this.setBucketQuota(bucketName, 0L, QuotaUnit.KB);
    }

    public Mono<Long> getBucketQuota(String bucketName) {
        return this.just("getBucketQuota", client -> client.getBucketQuota(bucketName));
    }
}

