/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.autoconfigure;

import cn.herodotus.oss.dialect.aliyun.config.OssDialectAliyunConfiguration;
import cn.herodotus.oss.dialect.autoconfigure.annotation.ConditionalOnUseAliyunDialect;
import cn.herodotus.oss.dialect.autoconfigure.annotation.ConditionalOnUseMinioDialect;
import cn.herodotus.oss.dialect.autoconfigure.annotation.ConditionalOnUseS3Dialect;
import cn.herodotus.oss.dialect.autoconfigure.customizer.OssErrorCodeMapperBuilderCustomizer;
import cn.herodotus.oss.dialect.autoconfigure.properties.OssProperties;
import cn.herodotus.oss.dialect.minio.config.OssDialectMinioConfiguration;
import cn.herodotus.oss.dialect.reactive.minio.config.OssDialectMinioReactiveConfiguration;
import cn.herodotus.oss.dialect.s3.config.OssDialectS3Configuration;
import cn.herodotus.oss.dialect.s3.reactive.config.OssDialectS3ReactiveConfiguration;
import cn.herodotus.stirrup.core.definition.function.ErrorCodeMapperBuilderCustomizer;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@EnableConfigurationProperties(value={OssProperties.class})
public class OssDialectAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OssDialectAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Starter [OSS Dialect] Configure.");
    }

    @Bean
    public ErrorCodeMapperBuilderCustomizer ossErrorCodeMapperBuilderCustomizer() {
        OssErrorCodeMapperBuilderCustomizer customizer = new OssErrorCodeMapperBuilderCustomizer();
        log.trace("[Herodotus] |- Strategy [Oss ErrorCodeMapper Builder Customizer] Configure.");
        return customizer;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnUseS3Dialect
    @Import(value={OssDialectS3Configuration.class, OssDialectS3ReactiveConfiguration.class})
    static class UserS3DialectConfiguration {
        UserS3DialectConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnUseMinioDialect
    @Import(value={OssDialectMinioConfiguration.class, OssDialectMinioReactiveConfiguration.class})
    static class UserMinioDialectConfiguration {
        UserMinioDialectConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnUseAliyunDialect
    @Import(value={OssDialectAliyunConfiguration.class})
    static class UserAliyunDialectConfiguration {
        UserAliyunDialectConfiguration() {
        }
    }
}

