/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.util;

import cn.hermesdi.crypto.constants.EncodingType;
import cn.hermesdi.crypto.exception.ApiCryptoExceptionType;
import cn.hermesdi.crypto.exception.ApiDecodeException;
import cn.hermesdi.crypto.exception.ApiEncryptException;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.encoders.UrlBase64;

public class EncodingUtil {
    private static final Log logger = LogFactory.getLog(EncodingUtil.class);

    public static String encode(EncodingType encodingType, byte[] encoding) {
        try {
            switch (encodingType) {
                case HEX: {
                    return Hex.toHexString((byte[])encoding);
                }
                case BASE64: {
                    return Base64.toBase64String((byte[])encoding);
                }
                case URL_BASE64: {
                    return new String(UrlBase64.encode((byte[])encoding));
                }
                case NONE: {
                    return new String(encoding);
                }
            }
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.ENCODING_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiEncryptException(exceptionType);
        }
        return null;
    }

    public static byte[] decode(EncodingType encodingType, byte[] encoding) {
        try {
            switch (encodingType) {
                case HEX: {
                    return Hex.decode((byte[])encoding);
                }
                case BASE64: {
                    return Base64.decode((byte[])encoding);
                }
                case URL_BASE64: {
                    return UrlBase64.decode((byte[])encoding);
                }
                case NONE: {
                    return encoding;
                }
            }
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.DECODING_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiDecodeException(exceptionType);
        }
        return null;
    }

    public static byte[] decode(EncodingType encodingType, String encoding, Charset charset) {
        return EncodingUtil.decode(encodingType, encoding.getBytes(charset));
    }
}

