/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.util;

import cn.hermesdi.crypto.constants.EncodingType;
import cn.hermesdi.crypto.constants.RSASignatureType;
import cn.hermesdi.crypto.util.EncodingUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoUtil {
    public static String digest(Digest digest, EncodingType encodingType, String content, Charset charset) {
        byte[] bytes = content.getBytes(charset);
        digest.update(bytes, 0, bytes.length);
        byte[] data = new byte[digest.getDigestSize()];
        digest.doFinal(data, 0);
        return EncodingUtil.encode(encodingType, data);
    }

    public static String symmetric(String type, String method, int mode, String key, String content, EncodingType encodingType, String iv, Charset charset) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(charset), type);
        Cipher cipher = Cipher.getInstance(method, "BC");
        if (Objects.nonNull(iv)) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes(charset));
            cipher.init(mode, (Key)secretKeySpec, ivSpec);
        } else {
            cipher.init(mode, secretKeySpec);
        }
        if (mode == 1) {
            return EncodingUtil.encode(encodingType, cipher.doFinal(content.getBytes(charset)));
        }
        if (mode == 2) {
            return new String(cipher.doFinal(EncodingUtil.decode(encodingType, content, charset)));
        }
        return null;
    }

    public static String asymmetry(String type, String method, int mode, String key, EncodingType keyEncodingType, String content, EncodingType contentEncodingType, Charset charset) throws Exception {
        byte[] decodeKey = EncodingUtil.decode(keyEncodingType, key.getBytes(charset));
        assert (decodeKey != null);
        KeyFactory keyFactory = KeyFactory.getInstance(type, "BC");
        Cipher cipher = Cipher.getInstance(method, "BC");
        if (mode == 1) {
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(decodeKey));
            cipher.init(1, publicKey);
            byte[] bytes = cipher.doFinal(content.getBytes(charset));
            return EncodingUtil.encode(contentEncodingType, bytes);
        }
        if (mode == 2) {
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decodeKey));
            cipher.init(2, privateKey);
            byte[] decodeContent = EncodingUtil.decode(contentEncodingType, content, charset);
            return new String(cipher.doFinal(decodeContent));
        }
        return null;
    }

    public static KeyPair generatorRsaKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize);
        return generator.generateKeyPair();
    }

    public static boolean resSignatureVerify(RSASignatureType rsaSignatureType, byte[] dataBytes, byte[] signatureBytes, byte[] publicKeyBytes) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        Signature signature = Signature.getInstance(rsaSignatureType.getType(), "BC");
        signature.initVerify(publicKey);
        signature.update(dataBytes);
        return signature.verify(signatureBytes);
    }

    public static byte[] resSignature(RSASignatureType rsaSignatureType, byte[] dataBytes, byte[] privateKeyBytes) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        Signature signature = Signature.getInstance(rsaSignatureType.getType(), "BC");
        signature.initSign(privateKey);
        signature.update(dataBytes);
        return signature.sign();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

