/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.algorithm;

import cn.hermesdi.crypto.algorithm.ApiCryptoAlgorithm;
import cn.hermesdi.crypto.annotation.SymmetricCrypto;
import cn.hermesdi.crypto.bean.ApiCryptoBody;
import cn.hermesdi.crypto.config.ApiCryptoConfig;
import cn.hermesdi.crypto.constants.EncodingType;
import cn.hermesdi.crypto.exception.ApiCryptoExceptionType;
import cn.hermesdi.crypto.exception.ApiDecodeException;
import cn.hermesdi.crypto.exception.ApiEncryptException;
import cn.hermesdi.crypto.ov.IApiRequestBody;
import cn.hermesdi.crypto.ov.IApiResponseBody;
import cn.hermesdi.crypto.util.CryptoUtil;
import cn.hermesdi.crypto.util.RandomStrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;

public class SymmetricApiCrypto
implements ApiCryptoAlgorithm {
    private static final Log logger = LogFactory.getLog(SymmetricApiCrypto.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiCryptoConfig apiCryptoConfig;
    private IApiRequestBody iApiRequestBody;
    private IApiResponseBody iApiResponseBody;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setiApiRequestBody(IApiRequestBody iApiRequestBody) {
        this.iApiRequestBody = iApiRequestBody;
    }

    public void setiApiResponseBody(IApiResponseBody iApiResponseBody) {
        this.iApiResponseBody = iApiResponseBody;
    }

    @Override
    public boolean isCanRealize(MethodParameter methodParameter, boolean requestOrResponse) {
        SymmetricCrypto annotation = this.getAnnotation(methodParameter, SymmetricCrypto.class);
        return !Objects.isNull(annotation);
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        String encryptData;
        SymmetricCrypto annotation = this.getAnnotation(methodParameter, SymmetricCrypto.class);
        ApiCryptoBody apiCryptoBody = this.requestBody(annotation, httpInputMessage, this.iApiRequestBody, this.objectMapper, logger);
        if (!StringUtils.hasText((String)apiCryptoBody.getData())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_DATA_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        if (annotation.type().isProduceIv()) {
            if (!StringUtils.hasText((String)apiCryptoBody.getIv())) {
                ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_VI_MISSING;
                logger.error((Object)exceptionType.getMessage());
                throw new ApiDecodeException(exceptionType);
            }
        } else {
            apiCryptoBody.setIv(null);
        }
        String secretKey = this.secretKey(annotation);
        EncodingType encodingType = this.apiCryptoConfig.getEncodingType();
        if (!annotation.encodingType().equals((Object)EncodingType.DEFAULT)) {
            encodingType = annotation.encodingType();
        }
        try {
            encryptData = CryptoUtil.symmetric(annotation.type().getType(), annotation.type().getMethod(), 2, secretKey, apiCryptoBody.getData(), encodingType, apiCryptoBody.getIv() != null ? apiCryptoBody.getIv() : null, this.apiCryptoConfig.getCharset());
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.DECRYPTION_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiDecodeException(exceptionType);
        }
        if (!StringUtils.hasText((String)encryptData)) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.DATA_EMPTY;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        return this.stringToInputStream(encryptData.getBytes(this.apiCryptoConfig.getCharset()), httpInputMessage.getHeaders(), logger);
    }

    @Override
    public Object responseBefore(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        String encryptData;
        SymmetricCrypto annotation = this.getAnnotation(methodParameter, SymmetricCrypto.class);
        String json = this.responseBody(body, this.objectMapper, logger);
        String secretKey = this.secretKey(annotation);
        String iv = null;
        if (annotation.type().isProduceIv()) {
            iv = RandomStrUtil.getRandomNumber(annotation.type().getIvLength());
        }
        if (StringUtils.hasText((String)annotation.SecretKey())) {
            secretKey = annotation.SecretKey();
        }
        EncodingType encodingType = this.apiCryptoConfig.getEncodingType();
        if (!annotation.encodingType().equals((Object)EncodingType.DEFAULT)) {
            encodingType = annotation.encodingType();
        }
        try {
            encryptData = CryptoUtil.symmetric(annotation.type().getType(), annotation.type().getMethod(), 1, secretKey, json, encodingType, iv, this.apiCryptoConfig.getCharset());
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.ENCRYPTION_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiEncryptException(exceptionType);
        }
        ApiCryptoBody apiCryptoBody = new ApiCryptoBody().setData(encryptData);
        if (annotation.type().isProduceIv()) {
            apiCryptoBody.setIv(iv);
        }
        if (this.iApiResponseBody != null) {
            return this.iApiResponseBody.responseBody(annotation, apiCryptoBody);
        }
        if (body instanceof String) {
            return this.responseBody(apiCryptoBody, this.objectMapper, logger);
        }
        return apiCryptoBody;
    }

    private String secretKey(SymmetricCrypto annotation) {
        String secretKey = this.apiCryptoConfig.getSymmetric().get(annotation.type().getType());
        if (StringUtils.hasText((String)annotation.SecretKey())) {
            secretKey = annotation.SecretKey();
        }
        if (!StringUtils.hasText((String)secretKey)) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.NO_SECRET_KEY;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a(\u65e0\u6548\u7684\u79d8\u94a5,\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6 symmetric \u6216\u6ce8\u89e3\u4e2d\u914d\u7f6e\u79d8\u94a5 secretKey )"));
            throw new ApiEncryptException(exceptionType);
        }
        return secretKey;
    }
}

