/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.algorithm;

import cn.hermesdi.crypto.algorithm.ApiCryptoAlgorithm;
import cn.hermesdi.crypto.annotation.SignatureCrypto;
import cn.hermesdi.crypto.bean.ApiCryptoBody;
import cn.hermesdi.crypto.config.ApiCryptoConfig;
import cn.hermesdi.crypto.exception.ApiCryptoExceptionType;
import cn.hermesdi.crypto.exception.ApiDecodeException;
import cn.hermesdi.crypto.exception.ApiEncryptException;
import cn.hermesdi.crypto.ov.IApiRequestBody;
import cn.hermesdi.crypto.ov.IApiResponseBody;
import cn.hermesdi.crypto.util.RandomStrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class SignatureApiCrypto
implements ApiCryptoAlgorithm {
    private static final Log logger = LogFactory.getLog(SignatureApiCrypto.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiCryptoConfig apiCryptoConfig;
    private IApiRequestBody iApiRequestBody;
    private IApiResponseBody iApiResponseBody;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setiApiRequestBody(IApiRequestBody iApiRequestBody) {
        this.iApiRequestBody = iApiRequestBody;
    }

    public void setiApiResponseBody(IApiResponseBody iApiResponseBody) {
        this.iApiResponseBody = iApiResponseBody;
    }

    @Override
    public boolean isCanRealize(MethodParameter methodParameter, boolean requestOrResponse) {
        SignatureCrypto annotation = this.getAnnotation(methodParameter, SignatureCrypto.class);
        return !Objects.isNull(annotation);
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        long time;
        SignatureCrypto annotation = this.getAnnotation(methodParameter, SignatureCrypto.class);
        ApiCryptoBody apiCryptoBody = this.requestBody(annotation, httpInputMessage, this.iApiRequestBody, this.objectMapper, logger);
        if (!StringUtils.hasText((String)apiCryptoBody.getData())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_DATA_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        if (!StringUtils.hasText((String)apiCryptoBody.getNonce())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_NONCE_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        if (Objects.isNull(apiCryptoBody.getTimestamp())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_TIMESTAMP_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        if (!StringUtils.hasText((String)apiCryptoBody.getSignStr())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_SIGN_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        long timeout = this.apiCryptoConfig.getSignature().getTimeout();
        if (annotation.timeout() > 0L) {
            timeout = annotation.timeout();
        }
        if (timeout > 0L && (time = System.currentTimeMillis() / 1000L - apiCryptoBody.getTimestamp()) > timeout) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.SIGNATURE_TIMED_OUT;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        String secretKey = this.apiCryptoConfig.getSignature().getSecretKey();
        if (StringUtils.hasText((String)annotation.SecretKey())) {
            secretKey = annotation.SecretKey();
        }
        if (!StringUtils.hasText((String)secretKey)) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.REQUIRED_SIGNATURE_PARAM;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        if (!this.signature(apiCryptoBody, secretKey).equals(apiCryptoBody.getSignStr())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.VERIFY_SIGNATURE_FAILED;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        return this.stringToInputStream(apiCryptoBody.getData().getBytes(this.apiCryptoConfig.getCharset()), httpInputMessage.getHeaders(), logger);
    }

    @Override
    public Object responseBefore(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        SignatureCrypto annotation = this.getAnnotation(methodParameter, SignatureCrypto.class);
        String json = this.responseBody(body, this.objectMapper, logger);
        String secretKey = this.apiCryptoConfig.getSignature().getSecretKey();
        if (StringUtils.hasText((String)annotation.SecretKey())) {
            secretKey = annotation.SecretKey();
        }
        ApiCryptoBody apiCryptoBody = new ApiCryptoBody();
        apiCryptoBody.setData(json);
        apiCryptoBody.setNonce(RandomStrUtil.getRandomNumber(32));
        apiCryptoBody.setTimestamp(System.currentTimeMillis() / 1000L);
        apiCryptoBody.setSignStr(this.signature(apiCryptoBody, secretKey));
        if (this.iApiResponseBody != null) {
            return this.iApiResponseBody.responseBody(annotation, apiCryptoBody);
        }
        if (body instanceof String) {
            return this.responseBody(apiCryptoBody, this.objectMapper, logger);
        }
        return apiCryptoBody;
    }

    private String signature(ApiCryptoBody apiCryptoBody, String secretKey) {
        try {
            String str = "data=" + apiCryptoBody.getData() + "&timestamp=" + apiCryptoBody.getTimestamp() + "&nonce=" + apiCryptoBody.getNonce() + "&key=" + secretKey;
            return DigestUtils.md5DigestAsHex((byte[])str.getBytes(this.apiCryptoConfig.getCharset()));
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.SIGNATURE_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiEncryptException(exceptionType);
        }
    }
}

