/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.algorithm;

import cn.hermesdi.crypto.algorithm.ApiCryptoAlgorithm;
import cn.hermesdi.crypto.annotation.EncodingCrypto;
import cn.hermesdi.crypto.bean.ApiCryptoBody;
import cn.hermesdi.crypto.config.ApiCryptoConfig;
import cn.hermesdi.crypto.constants.EncodingType;
import cn.hermesdi.crypto.exception.ApiCryptoExceptionType;
import cn.hermesdi.crypto.exception.ApiDecodeException;
import cn.hermesdi.crypto.ov.IApiRequestBody;
import cn.hermesdi.crypto.ov.IApiResponseBody;
import cn.hermesdi.crypto.util.EncodingUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;

public class EncodingApiCrypto
implements ApiCryptoAlgorithm {
    private static final Log logger = LogFactory.getLog(EncodingApiCrypto.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiCryptoConfig apiCryptoConfig;
    private IApiRequestBody iApiRequestBody;
    private IApiResponseBody iApiResponseBody;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setiApiRequestBody(IApiRequestBody iApiRequestBody) {
        this.iApiRequestBody = iApiRequestBody;
    }

    public void setiApiResponseBody(IApiResponseBody iApiResponseBody) {
        this.iApiResponseBody = iApiResponseBody;
    }

    @Override
    public boolean isCanRealize(MethodParameter methodParameter, boolean requestOrResponse) {
        EncodingCrypto annotation = this.getAnnotation(methodParameter, EncodingCrypto.class);
        return !Objects.isNull(annotation);
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        EncodingCrypto annotation = this.getAnnotation(methodParameter, EncodingCrypto.class);
        ApiCryptoBody apiCryptoBody = this.requestBody(annotation, httpInputMessage, this.iApiRequestBody, this.objectMapper, logger);
        if (!StringUtils.hasText((String)apiCryptoBody.getData())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_DATA_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        EncodingType encodingType = this.apiCryptoConfig.getEncodingType();
        if (!annotation.encodingType().equals((Object)EncodingType.DEFAULT)) {
            encodingType = annotation.encodingType();
        }
        byte[] decode = EncodingUtil.decode(encodingType, apiCryptoBody.getData().getBytes(this.apiCryptoConfig.getCharset()));
        return this.stringToInputStream(decode, httpInputMessage.getHeaders(), logger);
    }

    @Override
    public Object responseBefore(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        EncodingCrypto annotation = this.getAnnotation(methodParameter, EncodingCrypto.class);
        String json = this.responseBody(body, this.objectMapper, logger);
        EncodingType encodingType = this.apiCryptoConfig.getEncodingType();
        if (!annotation.encodingType().equals((Object)EncodingType.DEFAULT)) {
            encodingType = annotation.encodingType();
        }
        String encode = EncodingUtil.encode(encodingType, json.getBytes(this.apiCryptoConfig.getCharset()));
        ApiCryptoBody apiCryptoBody = new ApiCryptoBody().setData(encode);
        if (this.iApiResponseBody != null) {
            return this.iApiResponseBody.responseBody(annotation, apiCryptoBody);
        }
        if (body instanceof String) {
            return this.responseBody(apiCryptoBody, this.objectMapper, logger);
        }
        return apiCryptoBody;
    }
}

