/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.algorithm;

import cn.hermesdi.crypto.algorithm.ApiCryptoAlgorithm;
import cn.hermesdi.crypto.annotation.AsymmetryCrypto;
import cn.hermesdi.crypto.bean.ApiCryptoBody;
import cn.hermesdi.crypto.config.ApiCryptoConfig;
import cn.hermesdi.crypto.constants.EncodingType;
import cn.hermesdi.crypto.exception.ApiCryptoExceptionType;
import cn.hermesdi.crypto.exception.ApiDecodeException;
import cn.hermesdi.crypto.exception.ApiEncryptException;
import cn.hermesdi.crypto.ov.IApiRequestBody;
import cn.hermesdi.crypto.ov.IApiResponseBody;
import cn.hermesdi.crypto.util.CryptoUtil;
import cn.hermesdi.crypto.util.EncodingUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;

public class AsymmetryApiCrypto
implements ApiCryptoAlgorithm {
    private static final Log logger = LogFactory.getLog(AsymmetryApiCrypto.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiCryptoConfig apiCryptoConfig;
    private IApiRequestBody iApiRequestBody;
    private IApiResponseBody iApiResponseBody;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setiApiRequestBody(IApiRequestBody iApiRequestBody) {
        this.iApiRequestBody = iApiRequestBody;
    }

    public void setiApiResponseBody(IApiResponseBody iApiResponseBody) {
        this.iApiResponseBody = iApiResponseBody;
    }

    @Override
    public boolean isCanRealize(MethodParameter methodParameter, boolean requestOrResponse) {
        AsymmetryCrypto annotation = this.getAnnotation(methodParameter, AsymmetryCrypto.class);
        return !Objects.isNull(annotation);
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        String encryptData;
        AsymmetryCrypto annotation = this.getAnnotation(methodParameter, AsymmetryCrypto.class);
        ApiCryptoBody apiCryptoBody = this.requestBody(annotation, httpInputMessage, this.iApiRequestBody, this.objectMapper, logger);
        if (annotation.verifySignature() && !StringUtils.hasText((String)apiCryptoBody.getSignStr())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_SIGN_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        if (!StringUtils.hasText((String)apiCryptoBody.getData())) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.PARAM_DATA_MISSING;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        String privateKey = this.getPrivateKey(annotation);
        String publicKey = this.getPublicKey(annotation);
        EncodingType contentEncodingType = this.getContentEncodingType(annotation);
        EncodingType keyEncodingType = this.getKeyEncodingType(annotation);
        if (annotation.verifySignature()) {
            boolean bo = false;
            try {
                bo = CryptoUtil.resSignatureVerify(annotation.signatureType(), EncodingUtil.decode(contentEncodingType, apiCryptoBody.getData(), this.apiCryptoConfig.getCharset()), EncodingUtil.decode(contentEncodingType, apiCryptoBody.getSignStr(), this.apiCryptoConfig.getCharset()), EncodingUtil.decode(keyEncodingType, publicKey, this.apiCryptoConfig.getCharset()));
            }
            catch (Exception e) {
                ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.VERIFY_SIGNATURE_FAILED;
                logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
                throw new ApiDecodeException(exceptionType);
            }
            if (!bo) {
                ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.VERIFY_SIGNATURE_FAILED;
                logger.error((Object)exceptionType.getMessage());
                throw new ApiDecodeException(exceptionType);
            }
        }
        try {
            encryptData = CryptoUtil.asymmetry(annotation.type().getType(), annotation.type().getMethod(), 2, privateKey, keyEncodingType, apiCryptoBody.getData(), contentEncodingType, this.apiCryptoConfig.getCharset());
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.DECRYPTION_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiDecodeException(exceptionType);
        }
        if (!StringUtils.hasText((String)encryptData)) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.DATA_EMPTY;
            logger.error((Object)exceptionType.getMessage());
            throw new ApiDecodeException(exceptionType);
        }
        return this.stringToInputStream(encryptData.getBytes(this.apiCryptoConfig.getCharset()), httpInputMessage.getHeaders(), logger);
    }

    @Override
    public Object responseBefore(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        String encryptData;
        AsymmetryCrypto annotation = this.getAnnotation(methodParameter, AsymmetryCrypto.class);
        String privateKey = this.getPrivateKey(annotation);
        String publicKey = this.getPublicKey(annotation);
        String json = this.responseBody(body, this.objectMapper, logger);
        EncodingType contentEncodingType = this.getContentEncodingType(annotation);
        EncodingType keyEncodingType = this.getKeyEncodingType(annotation);
        try {
            encryptData = CryptoUtil.asymmetry(annotation.type().getType(), annotation.type().getMethod(), 1, publicKey, keyEncodingType, json, contentEncodingType, this.apiCryptoConfig.getCharset());
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.ENCRYPTION_FAILED;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiEncryptException(exceptionType);
        }
        ApiCryptoBody apiCryptoBody = new ApiCryptoBody().setData(encryptData);
        if (annotation.signature()) {
            byte[] signature = null;
            try {
                signature = CryptoUtil.resSignature(annotation.signatureType(), EncodingUtil.decode(contentEncodingType, apiCryptoBody.getData(), this.apiCryptoConfig.getCharset()), EncodingUtil.decode(keyEncodingType, privateKey, this.apiCryptoConfig.getCharset()));
            }
            catch (Exception e) {
                ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.SIGNATURE_FAILED;
                logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
                throw new ApiDecodeException(exceptionType);
            }
            if (Objects.isNull(signature) || signature.length < 1) {
                ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.SIGNATURE_FAILED;
                logger.error((Object)exceptionType.getMessage());
                throw new ApiDecodeException(exceptionType);
            }
            apiCryptoBody.setSignStr(EncodingUtil.encode(contentEncodingType, signature));
        }
        if (this.iApiResponseBody != null) {
            return this.iApiResponseBody.responseBody(annotation, apiCryptoBody);
        }
        if (body instanceof String) {
            return this.responseBody(apiCryptoBody, this.objectMapper, logger);
        }
        return apiCryptoBody;
    }

    private String getPrivateKey(AsymmetryCrypto annotation) {
        String privateKey;
        String string = privateKey = StringUtils.hasText((String)annotation.privateKey()) ? annotation.privateKey() : this.apiCryptoConfig.getAsymmetry().get(annotation.type().getType()).getPrivateKey();
        if (!StringUtils.hasText((String)privateKey)) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.NO_PRIVATE_KEY;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a(\u65e0\u6548\u7684\u79d8\u94a5,\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6 asymmetry \u6216\u6ce8\u89e3\u4e2d\u914d\u7f6e\u79d8\u94a5 privateKey)"));
            throw new ApiEncryptException(exceptionType);
        }
        return privateKey;
    }

    private String getPublicKey(AsymmetryCrypto annotation) {
        String publicKey;
        String string = publicKey = StringUtils.hasText((String)annotation.publicKey()) ? annotation.publicKey() : this.apiCryptoConfig.getAsymmetry().get(annotation.type().getType()).getPublicKey();
        if (!StringUtils.hasText((String)publicKey)) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.NO_PUBLIC_KEY;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a(\u65e0\u6548\u7684\u79d8\u94a5,\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6 asymmetry \u6216\u6ce8\u89e3\u4e2d\u914d\u7f6e\u79d8\u94a5 publicKey)"));
            throw new ApiEncryptException(exceptionType);
        }
        return publicKey;
    }

    private EncodingType getContentEncodingType(AsymmetryCrypto annotation) {
        EncodingType encodingType = this.apiCryptoConfig.getEncodingType();
        if (!annotation.contentEncodingType().equals((Object)EncodingType.DEFAULT)) {
            encodingType = annotation.contentEncodingType();
        }
        return encodingType;
    }

    private EncodingType getKeyEncodingType(AsymmetryCrypto annotation) {
        EncodingType encodingType = this.apiCryptoConfig.getEncodingType();
        if (!annotation.keyEncodingType().equals((Object)EncodingType.DEFAULT)) {
            encodingType = annotation.keyEncodingType();
        }
        return encodingType;
    }
}

