/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.algorithm;

import cn.hermesdi.crypto.bean.ApiCryptoBody;
import cn.hermesdi.crypto.bean.InputMessage;
import cn.hermesdi.crypto.exception.ApiCryptoExceptionType;
import cn.hermesdi.crypto.exception.ApiDecodeException;
import cn.hermesdi.crypto.exception.ApiEncryptException;
import cn.hermesdi.crypto.ov.IApiRequestBody;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public interface ApiCryptoAlgorithm {
    public boolean isCanRealize(MethodParameter var1, boolean var2);

    default public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) throws IOException {
        return httpInputMessage;
    }

    default public Object responseBefore(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        return body;
    }

    default public <A extends Annotation> A getAnnotation(MethodParameter methodParameter, Class<A> annotationType) {
        return (A)Optional.ofNullable(methodParameter.getMethodAnnotation(annotationType)).orElse((Annotation)methodParameter.getDeclaringClass().getAnnotation(annotationType));
    }

    default public InputMessage stringToInputStream(byte[] bytes, HttpHeaders httpHeaders, Log logger) {
        try {
            if (!1.$assertionsDisabled && bytes == null) {
                throw new AssertionError();
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            return new InputMessage(inputStream, httpHeaders);
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.STRING_TO_INPUT_STREAM;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiDecodeException(exceptionType);
        }
    }

    default public ApiCryptoBody requestBody(Annotation annotation, HttpInputMessage httpInputMessage, IApiRequestBody iApiRequestBody, ObjectMapper objectMapper, Log logger) {
        ApiCryptoBody apiCryptoBody;
        try {
            apiCryptoBody = iApiRequestBody != null ? iApiRequestBody.requestBody(annotation, httpInputMessage.getBody()) : (ApiCryptoBody)objectMapper.readValue(httpInputMessage.getBody(), ApiCryptoBody.class);
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.REQUEST_TO_BEAN;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiDecodeException(exceptionType);
        }
        return apiCryptoBody;
    }

    default public String responseBody(Object body, ObjectMapper objectMapper, Log logger) {
        String json;
        if (body instanceof String) {
            return (String)body;
        }
        try {
            json = objectMapper.writeValueAsString(body);
        }
        catch (Exception e) {
            ApiCryptoExceptionType exceptionType = ApiCryptoExceptionType.RESPONSE_TO_JSON;
            logger.error((Object)(exceptionType.getMessage() + " ERROR\uff1a" + e.getMessage()));
            throw new ApiEncryptException(exceptionType);
        }
        return json;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

