/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.advice;

import cn.hermesdi.crypto.algorithm.ApiCryptoAlgorithm;
import cn.hermesdi.crypto.annotation.NotEncrypt;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object>,
Serializable {
    private static final Log logger = LogFactory.getLog(EncryptResponseBodyAdvice.class);
    private ApiCryptoAlgorithm apiCryptoAlgorithm;
    private final List<ApiCryptoAlgorithm> apiCryptoAlgorithms;

    public EncryptResponseBodyAdvice(List<ApiCryptoAlgorithm> apiCryptoAlgorithms) {
        this.apiCryptoAlgorithms = apiCryptoAlgorithms;
    }

    public boolean supports(MethodParameter parameter, Class<? extends HttpMessageConverter<?>> aClass) {
        if (parameter.hasMethodAnnotation(NotEncrypt.class)) {
            return false;
        }
        if (Objects.nonNull(this.apiCryptoAlgorithms) && !this.apiCryptoAlgorithms.isEmpty()) {
            logger.debug((Object)("\u3010ApiCrypto\u3011 all Encrypt Algorithm : [" + this.apiCryptoAlgorithms + "]"));
            for (ApiCryptoAlgorithm a : this.apiCryptoAlgorithms) {
                if (!a.isCanRealize(parameter, false)) continue;
                this.apiCryptoAlgorithm = a;
                return true;
            }
        } else {
            logger.debug((Object)"\u3010ApiCrypto\u3011 no Encrypt Algorithm.( \u6ca1\u6709\u53ef\u7528\u7684 ApiCryptoAlgorithm \u5b9e\u73b0 )");
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        return this.apiCryptoAlgorithm.responseBefore(body, methodParameter, mediaType, aClass, serverHttpRequest, serverHttpResponse);
    }
}

