/*
 * Decompiled with CFR 0.152.
 */
package cn.hermesdi.crypto.advice;

import cn.hermesdi.crypto.algorithm.ApiCryptoAlgorithm;
import cn.hermesdi.crypto.annotation.NotDecrypt;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Log logger = LogFactory.getLog(DecryptRequestBodyAdvice.class);
    private ApiCryptoAlgorithm apiCryptoAlgorithm;
    private final List<ApiCryptoAlgorithm> apiCryptoAlgorithms;

    public DecryptRequestBodyAdvice(List<ApiCryptoAlgorithm> apiCryptoAlgorithms) {
        this.apiCryptoAlgorithms = apiCryptoAlgorithms;
    }

    public boolean supports(MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        if (parameter.hasMethodAnnotation(NotDecrypt.class)) {
            return false;
        }
        if (Objects.nonNull(this.apiCryptoAlgorithms) && !this.apiCryptoAlgorithms.isEmpty()) {
            logger.debug((Object)("\u3010ApiCrypto\u3011 all Decrypt Algorithm : [" + this.apiCryptoAlgorithms + "]"));
            for (ApiCryptoAlgorithm a : this.apiCryptoAlgorithms) {
                if (!a.isCanRealize(parameter, false)) continue;
                this.apiCryptoAlgorithm = a;
                return true;
            }
        } else {
            logger.debug((Object)"\u3010ApiCrypto\u3011 no Decrypt Algorithm.( \u6ca1\u6709\u53ef\u7528\u7684 ApiCryptoAlgorithm \u5b9e\u73b0 )");
        }
        return false;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return this.apiCryptoAlgorithm.beforeBodyRead(inputMessage, parameter, targetType, converterType);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

