/*
 * Decompiled with CFR 0.152.
 */
package cn.hchub.springboot.swagger3.gateway;

import java.util.ArrayList;
import java.util.List;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ComponentScan(basePackages={"cn.hchub.springboot.swagger3.gateway"})
public class SpringdocOpenapiGatewayConfiguration {
    @Bean
    @Lazy(value=false)
    public List<GroupedOpenApi> apis(SwaggerUiConfigParameters swaggerUiConfigParameters, RouteDefinitionLocator locator) {
        ArrayList<GroupedOpenApi> groups = new ArrayList<GroupedOpenApi>();
        List definitions = (List)locator.getRouteDefinitions().collectList().block();
        definitions.stream().filter(routeDefinition -> routeDefinition.getId().matches(".*-service")).forEach(routeDefinition -> {
            String name = routeDefinition.getId().replaceAll("-service", "");
            swaggerUiConfigParameters.addGroup(name);
            GroupedOpenApi.builder().pathsToMatch(new String[]{"/" + name + "/**"}).group(name).build();
        });
        return groups;
    }
}

