package cn.hchub.groovy.script;

import lombok.extern.slf4j.Slf4j;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

@Slf4j
public class GroovyScriptMemoryFactory implements GroovyScriptFactory {

    private static ConcurrentMap<String, GroovyScript> groovyBeanMap = new ConcurrentHashMap<>();
    private static ConcurrentMap<String, GroovyScript> groovyScriptIdMap = new ConcurrentHashMap<>();

    @Override
    public void setScripts(Set<GroovyScript> groovyScripts) {
        groovyBeanMap = groovyScripts.stream().collect(Collectors.toConcurrentMap(GroovyScript::getBeanName, GroovyScript -> GroovyScript));
        groovyScriptIdMap = groovyScripts.stream().collect(Collectors.toConcurrentMap(GroovyScript::getId, GroovyScript -> GroovyScript));
    }

    @Override
    public GroovyScript getByBeanName(String beanName) {
        return groovyBeanMap.get(beanName);
    }

    @Override
    public GroovyScript getByScriptId(String scriptId) {
        return groovyScriptIdMap.get(scriptId);
    }
}
