package cn.hchub.groovy.script;


import cn.hchub.groovy.GroovyBaseDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GroovyScript extends GroovyBaseDTO {
    @Schema(description = "groovy脚本Id")
    @NotBlank
    private String id;

    @Schema(description = "groovy脚本实例化对象名")
    @NotBlank
    private String beanName;

    @Schema(description = "groovy脚本内容")
    @NotBlank
    private String groovyContent;
}
