package cn.hchub.groovy.engine;

import cn.hchub.groovy.script.GroovyScriptFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class GroovyParserEngine implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Autowired
    private GroovyScriptFactory groovyScriptFactory;
    public <REQ extends GroovyBaseRequestDTO,RES extends GroovyBaseResponseDTO> RES parse( REQ requestDTO){
        String beanName = groovyScriptFactory.getByBeanName(requestDTO.getScriptId()).getBeanName();
        GroovyParser<REQ,RES> parser = (GroovyParser) applicationContext.getBean(beanName);
        return parser.parse(requestDTO);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
       this.applicationContext = applicationContext;
    }
}
