package cn.hchub.groovy.config;

import cn.hchub.groovy.BeanElement;
import cn.hchub.groovy.GroovyScriptBeanReader;
import cn.hchub.groovy.engine.GroovyParser;
import cn.hchub.groovy.script.GroovyScript;
import cn.hchub.groovy.script.GroovyScriptFactory;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.xml.sax.SAXException;

import javax.annotation.PostConstruct;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.util.Set;

@Slf4j
@Data
@Configuration
@ConfigurationProperties(prefix = "spring.groovy.config")
public class GroovyScriptConfig {
    private boolean enable;
    private Set<GroovyScript> groovyScripts;
    @Autowired
    private GroovyScriptBeanReader groovyScriptBeanReader;
    @Autowired
    private GroovyScriptFactory groovyScriptFactory;

    @PostConstruct
    public void loadingGroovyScript() {
        log.info("groovy script loading from config,enable:{}", this.enable);
        if (!this.enable) {
            return;
        }
        groovyScriptFactory.setScripts(groovyScripts);
        Set<String> msgs = null;
        try {
            msgs = groovyScriptBeanReader.loadScript(groovyScripts);
        } catch (ParserConfigurationException | IOException | TransformerException | SAXException e) {
            log.error("groovy script loading from config exception",e);
        }
        Set<BeanElement> elements  = groovyScriptBeanReader.getBeans(GroovyParser.class);
        log.info("groovy script loading from config finished:{},Beans:{}", StringUtils.join(msgs, ","),elements);
    }
}
