/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2011 All Rights Reserved.
 */
package cn.hchub.groovy;

import cn.hchub.groovy.script.GroovyScriptFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.ScriptFactoryPostProcessor;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.stereotype.Service;

/**
 * 修改自ScriptFactoryPostProcessor
 * 实现定制的Groovy脚本后处理器，用来定制数据库的脚本加载处理
 * 实现了针对单独脚本进行更新的功能
 */
@Service
public class GroovyScriptFactoryPostProcessor extends ScriptFactoryPostProcessor {
    @Autowired
    private GroovyScriptFactory groovyScriptFactory;

    /**
     * 根据beanName转换成ScriptSource
     *
     * @param beanName
     * @param scriptSourceLocator
     * @param loader
     * @return
     */
    @Override
    protected ScriptSource convertToScriptSource(String beanName, String scriptSourceLocator,
                                                 ResourceLoader loader) {
        if (scriptSourceLocator.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(scriptSourceLocator.substring(INLINE_SCRIPT_PREFIX
                    .length()), beanName);
        } else if (scriptSourceLocator.startsWith(DatabaseScriptSource.SCRIPT_SOURCE_PREFIX)) {
            String groovyTagId = StringUtils.substringAfter(scriptSourceLocator,
                    DatabaseScriptSource.SCRIPT_SOURCE_PREFIX);
            return new DatabaseScriptSource(groovyTagId, groovyScriptFactory);
        } else {
            return new ResourceScriptSource(loader.getResource(scriptSourceLocator));
        }
    }

}